<?php
/**
 * Create user custom fields while registration module activate.
 *
 * @package Wordpress
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

add_action( 'admin_init', 'create_default_registration_customfields' );
/**
 * Check if auto install completed then perform below step incase user deteleted default settings.
 */
function create_default_registration_customfields() {
	global $wpdb, $pagenow;
	if ( get_option( 'tmpl_is_tev_auto_insall' ) == 'true' || (is_admin() && defined( 'DOING_AJAX' ) && DOING_AJAX ) ) :
		if ( get_option( 'tmpl_is_tev_auto_insall' ) == 'false' && is_admin() && defined( 'DOING_AJAX' ) && DOING_AJAX ) { $pagenow = 'plugins.php'; }
		if ( ( isset( $_REQUEST['activated'] ) && 'templatic-login' == wp_kses_post( wp_unslash( $_REQUEST['activated'] ) ) && isset( $_REQUEST['true'] ) && 1 == wp_kses_post( wp_unslash( $_REQUEST['true'] ) ) ) || ( isset( $_REQUEST['page'] ) && 'templatic_system_menu' == wp_kses_post( wp_unslash( $_REQUEST['page'] ) ) && isset( $_REQUEST['activated'] ) && 'true' == wp_kses_post( wp_unslash( $_REQUEST['activated'] ) ) ) || 'plugins.php' == $pagenow || 'themes.php' == $pagenow ) {

			/* insert two fields of user name and email while activation this meta box */
			global $current_user, $wpdb;
			$postname = 'user_email';
			$postid = $wpdb->get_var( "SELECT ID FROM $wpdb->posts WHERE post_name = '" . $postname . "'" );
			if ( ! $postid ) {
				$args = array(
				'public' => true,
				'label' => 'User Fields',
					);
					register_post_type( 'custom_user_field', $args );
					$tmpdata = get_option( 'templatic_settings' );
					$tmpdata['allow_autologin_after_reg'] = 'No';
					$tmpdata['show_dashboard_bar'] = 'No';
				update_option( 'templatic_settings', $tmpdata );
				$my_post = array();
				$my_post['post_title'] = 'Email';
				$my_post['post_name'] = 'user_email';
				$my_post['post_content'] = '';
				$my_post['post_status'] = 'publish';
				$my_post['post_author'] = 1;
				$my_post['post_type'] = 'custom_user_field';
				$custom = array(
				'ctype'		   => 'text',
				'sort_order' 		=> '1',
				'on_registration'	=> '1',
				'on_profile'		=> '1',
				'option_values'	=> '',
				'is_require'		=> '1',
				'on_author_page'	=> '1',
				);
				$last_postid = wp_insert_post( $my_post );
				/* Finish the place geo_latitude and geo_longitude in postcodes table*/
				if ( is_plugin_active( 'sitepress-multilingual-cms/sitepress.php' ) ) {
					if ( function_exists( 'wpml_insert_templ_post' ) ) {
						wpml_insert_templ_post( $last_postid, 'custom_user_field' ); /* insert post in language */
					}
				}
				foreach ( $custom as $key => $val ) {
					update_post_meta( $last_postid, $key, $val );
				}
			} // End if().
			$postname = 'user_fname';
			$postid = $wpdb->get_var( "SELECT ID FROM $wpdb->posts WHERE post_name = '" . $postname . "'" );
			if ( ! $postid ) {
				/* User Name custom field */
				$my_post = array();
				$my_post['post_title'] = 'Username';
				$my_post['post_name']  = 'user_fname';
				$my_post['post_content'] = '';
				$my_post['post_status'] = 'publish';
				$my_post['post_author'] = 1;
				$my_post['post_type']  = 'custom_user_field';
				$custom = array(
				'ctype'		   => 'text',
				'sort_order' 		=> '2',
				'on_registration'	=> '1',
				'on_profile'		=> '1',
				'option_values'	=> '',
				'is_require'		=> '1',
				'on_author_page'	=> '1',
				);
				$last_postid = wp_insert_post( $my_post );
				/* Finish the place geo_latitude and geo_longitude in postcodes table*/
				if ( is_plugin_active( 'sitepress-multilingual-cms/sitepress.php' ) ) {
					if ( function_exists( 'wpml_insert_templ_post' ) ) {
						wpml_insert_templ_post( $last_postid, 'custom_user_field' ); /* insert post in language */
					}
				}
				foreach ( $custom as $key => $val ) {
					update_post_meta( $last_postid, $key, $val );
				}
			}
			$display_name = 'display_name';
			$display_namepostid = $wpdb->get_var( "SELECT ID FROM $wpdb->posts WHERE post_name = '" . $display_name . "'" );
			if ( ! $display_namepostid ) {
				/* website url custom field */
				$my_post = array();
				$my_post['post_title'] = 'Display Name';
				$my_post['post_name']  = 'display_name';
				$my_post['post_content'] = '';
				$my_post['post_status'] = 'publish';
				$my_post['post_author'] = 1;
				$my_post['post_type']  = 'custom_user_field';
				$custom = array(
				'ctype'		   => 'text',
				'sort_order' 		=> '3',
				'on_registration'	=> '0',
				'on_profile'		=> '1',
				'option_values'	=> '',
				'is_require'		=> '0',
				'on_author_page'	=> '1',
				);
				$last_postid = wp_insert_post( $my_post );
				/* Finish the place geo_latitude and geo_longitude in postcodes table*/
				if ( is_plugin_active( 'sitepress-multilingual-cms/sitepress.php' ) ) {
					if ( function_exists( 'wpml_insert_templ_post' ) ) {
						wpml_insert_templ_post( $last_postid, 'custom_user_field' ); /* insert post in language */
					}
				}
				foreach ( $custom as $key => $val ) {
					update_post_meta( $last_postid, $key, $val );
				}
			}
			$user_google = 'user_google';
			$user_google_id = $wpdb->get_var( "SELECT ID FROM $wpdb->posts WHERE post_name = '" . $user_google . "'" );
			if ( ! $user_google_id ) {
				/* website url custom field */
				$my_post = array();
				$my_post['post_title'] = 'Google+';
				$my_post['post_name']  = 'user_google';
				$my_post['post_content'] = '';
				$my_post['post_status'] = 'publish';
				$my_post['post_author'] = 1;
				$my_post['post_type']  = 'custom_user_field';
				$custom = array(
					'ctype'		   => 'text',
				'sort_order' 		=> '3',
				'on_registration'	=> '0',
				'on_profile'		=> '1',
				'option_values'	=> '',
				'is_require'		=> '0',
				'on_author_page'	=> '1',
				);
				$last_postid = wp_insert_post( $my_post );
				/* Finish the place geo_latitude and geo_longitude in postcodes table*/
				if ( is_plugin_active( 'sitepress-multilingual-cms/sitepress.php' ) ) {
					if ( function_exists( 'wpml_insert_templ_post' ) ) {
						wpml_insert_templ_post( $last_postid, 'custom_user_field' ); /* insert post in language */
					}
				}
				foreach ( $custom as $key => $val ) {
					update_post_meta( $last_postid, $key, $val );
				}
			}
			$website = 'url';
			$websitepostid = $wpdb->get_var( "SELECT ID FROM $wpdb->posts WHERE post_name = '" . $website . "'" );
			if ( ! $websitepostid ) {
				/* website url custom field */
				$my_post = array();
				$my_post['post_title'] = 'Website';
				$my_post['post_name']  = 'url';
				$my_post['post_content'] = '';
				$my_post['post_status'] = 'publish';
				$my_post['post_author'] = 1;
				$my_post['post_type']  = 'custom_user_field';
				$custom = array(
				'ctype'		   => 'text',
				'sort_order' 		=> '4',
				'on_registration'	=> '0',
				'on_profile'		=> '1',
				'option_values'	=> '',
				'is_require'		=> '0',
				'on_author_page'	=> '1',
				);
				$last_postid = wp_insert_post( $my_post );
				/* Finish the place geo_latitude and geo_longitude in postcodes table*/
				if ( is_plugin_active( 'sitepress-multilingual-cms/sitepress.php' ) ) {
					if ( function_exists( 'wpml_insert_templ_post' ) ) {
						wpml_insert_templ_post( $last_postid, 'custom_user_field' ); /* insert post in language */
					}
				}
				foreach ( $custom as $key => $val ) {
					update_post_meta( $last_postid, $key, $val );
				}
			}
			$user_phone = 'user_phone';
			$user_phonepostid = $wpdb->get_var( "SELECT ID FROM $wpdb->posts WHERE post_name = '" . $user_phone . "'" );
			if ( ! $user_phonepostid ) {
				/* website url custom field */
				$my_post = array();
				$my_post['post_title'] = 'Phone';
				$my_post['post_name']  = 'user_phone';
				$my_post['post_content'] = '';
				$my_post['post_status'] = 'publish';
				$my_post['post_author'] = 1;
				$my_post['post_type']  = 'custom_user_field';
				$custom = array(
				'ctype'		   => 'text',
				'sort_order' 		=> '5',
				'on_registration'	=> '0',
				'on_profile'		=> '1',
				'option_values'	=> '',
				'is_require'		=> '0',
				'on_author_page'	=> '1',
				);
				$last_postid = wp_insert_post( $my_post );
				/* Finish the place geo_latitude and geo_longitude in postcodes table*/
				if ( is_plugin_active( 'sitepress-multilingual-cms/sitepress.php' ) ) {
					if ( function_exists( 'wpml_insert_templ_post' ) ) {
						wpml_insert_templ_post( $last_postid, 'custom_user_field' ); /* insert post in language */
					}
				}
				foreach ( $custom as $key => $val ) {
					update_post_meta( $last_postid, $key, $val );
				}
			}
			$facebook = 'facebook';
			$facebookpostid = $wpdb->get_var( "SELECT ID FROM $wpdb->posts WHERE post_name = '" . $facebook . "'" );
			if ( ! $facebookpostid ) {
				/* Facebook url custom field */
				$my_post = array();
				$my_post['post_title'] = 'Facebook';
				$my_post['post_name']  = 'facebook';
				$my_post['post_content'] = '';
				$my_post['post_status'] = 'publish';
				$my_post['post_author'] = 1;
				$my_post['post_type']  = 'custom_user_field';
				$custom = array(
				'ctype'		   => 'text',
				'sort_order' 		=> '6',
				'on_registration'	=> '0',
				'on_profile'		=> '1',
				'option_values'	=> '',
				'is_require'		=> '0',
				'on_author_page'	=> '1',
				);
				$last_postid = wp_insert_post( $my_post );
				/* Finish the place geo_latitude and geo_longitude in postcodes table*/
				if ( is_plugin_active( 'sitepress-multilingual-cms/sitepress.php' ) ) {
					if ( function_exists( 'wpml_insert_templ_post' ) ) {
						wpml_insert_templ_post( $last_postid, 'custom_user_field' ); /* insert post in language */
					}
				}
				foreach ( $custom as $key => $val ) {
					update_post_meta( $last_postid, $key, $val );
				}
			}
			$twitter = 'twitter';
			$twitterpostid = $wpdb->get_var( "SELECT ID FROM $wpdb->posts WHERE post_name = '" . $twitter . "'" );
			if ( ! $twitterpostid ) {
				/* Twitter url custom field */
				$my_post = array();
				$my_post['post_title'] = 'Twitter';
				$my_post['post_name']  = 'twitter';
				$my_post['post_content'] = '';
				$my_post['post_status'] = 'publish';
				$my_post['post_author'] = 1;
				$my_post['post_type']  = 'custom_user_field';
				$custom = array(
				'ctype'		   => 'text',
				'sort_order' 		=> '7',
				'on_registration'	=> '0',
				'on_profile'		=> '1',
				'option_values'	=> '',
				'is_require'		=> '0',
				'on_author_page'	=> '1',
				);
				$last_postid = wp_insert_post( $my_post );
				/* Finish the place geo_latitude and geo_longitude in postcodes table*/
				if ( is_plugin_active( 'sitepress-multilingual-cms/sitepress.php' ) ) {
					if ( function_exists( 'wpml_insert_templ_post' ) ) {
						wpml_insert_templ_post( $last_postid, 'custom_user_field' ); /* insert post in language */
					}
				}
				foreach ( $custom as $key => $val ) {
					update_post_meta( $last_postid, $key, $val );
				}
			}
			$linkedin = 'linkedin';
			$linkedinpostid = $wpdb->get_var( "SELECT ID FROM $wpdb->posts WHERE post_name = '" . $linkedin . "'" );
			if ( ! $linkedinpostid ) {
				/* Linkedin url custom field */
				$my_post = array();
				$my_post['post_title'] = 'LinkedIn';
				$my_post['post_name']  = 'linkedin';
				$my_post['post_content'] = '';
				$my_post['post_status'] = 'publish';
				$my_post['post_author'] = 1;
				$my_post['post_type']  = 'custom_user_field';
				$custom = array(
				'ctype'		   => 'text',
				'sort_order' 		=> '8',
				'on_registration'	=> '0',
				'on_profile'		=> '1',
				'option_values'	=> '',
				'is_require'		=> '0',
				'on_author_page'	=> '1',
				);
				$last_postid = wp_insert_post( $my_post );
				/* Finish the place geo_latitude and geo_longitude in postcodes table*/
				if ( is_plugin_active( 'sitepress-multilingual-cms/sitepress.php' ) ) {
					if ( function_exists( 'wpml_insert_templ_post' ) ) {
						wpml_insert_templ_post( $last_postid, 'custom_user_field' ); /* insert post in language */
					}
				}
				foreach ( $custom as $key => $val ) {
					update_post_meta( $last_postid, $key, $val );
				}
			}
			$description = 'description';
			$descriptionpostid = $wpdb->get_var( "SELECT ID FROM $wpdb->posts WHERE post_name = '" . $description . "'" );
			if ( ! $descriptionpostid ) {
				/* Author Biography custom field */
				$my_post = array();
				$my_post['post_title'] = 'Author Biography';
				$my_post['post_name']  = 'description';
				$my_post['post_content'] = '';
				$my_post['post_status'] = 'publish';
				$my_post['post_author'] = 1;
				$my_post['post_type']  = 'custom_user_field';
				$custom = array(
				'ctype'		   => 'texteditor',
				'sort_order' 		=> '9',
				'on_registration'	=> '0',
				'on_profile'		=> '1',
				'option_values'	=> '',
				'is_require'		=> '0',
				'on_author_page'	=> '1',
				);
				$last_postid = wp_insert_post( $my_post );
				/* Finish the place geo_latitude and geo_longitude in postcodes table*/
				if ( is_plugin_active( 'sitepress-multilingual-cms/sitepress.php' ) ) {
					if ( function_exists( 'wpml_insert_templ_post' ) ) {
						wpml_insert_templ_post( $last_postid, 'custom_user_field' ); /* insert post in language */
					}
				}
				foreach ( $custom as $key => $val ) {
					update_post_meta( $last_postid, $key, $val );
				}
			}
			$profile_photo = 'profile_photo';
			$profile_photopostid = $wpdb->get_var( "SELECT ID FROM $wpdb->posts WHERE post_name = '" . $profile_photo . "'" );
			if ( ! $profile_photopostid ) {
				/* Linked in url custom field */
				$my_post = array();
				$my_post['post_title'] = 'Profile Photo';
				$my_post['post_name']  = 'profile_photo';
				$my_post['post_content'] = '';
				$my_post['post_status'] = 'publish';
				$my_post['post_author'] = 1;
				$my_post['post_type']  = 'custom_user_field';
				$custom = array(
				'ctype'		   => 'upload',
				'sort_order' 		=> '10',
				'on_registration'	=> '0',
				'on_profile'		=> '1',
				'option_values'	=> '',
				'is_require'		=> '0',
				'on_author_page'	=> '1',
				);
				$last_postid = wp_insert_post( $my_post );
					/* Finish the place geo_latitude and geo_longitude in postcodes table*/
				if ( is_plugin_active( 'sitepress-multilingual-cms/sitepress.php' ) ) {
					if ( function_exists( 'wpml_insert_templ_post' ) ) {
						wpml_insert_templ_post( $last_postid, 'custom_user_field' ); /* insert post in language */
					}
				}
				foreach ( $custom as $key => $val ) {
					update_post_meta( $last_postid, $key, $val );
				}
			}
			global $wp_post_types;
			if ( isset( $wp_post_types['custom_user_field'] ) ) {
				unset( $wp_post_types['custom_user_field'] );
			}
			/*Register Module auto install page like login, register, profile*/
			add_action( 'admin_init', 'register_module_insert_page', 100 );
			/*end Register Module auto install page like login, register, profile*/
		} // End if().
	endif;

}

/* Email Settings */
add_action( 'templatic_general_data_email', 'registration_email_setting_data', 11 );
add_action( 'templatic_general_data_email', 'legends_email_setting_data', 15 );
add_action( 'templatic_general_setting_data', 'templatic_general_setting_register_data', 11 );

/**
 * Add Filter for create the general setting sub tab for email setting.
 *
 * @param array $tabs 		Add email seetings.
 */
function registration_email_setting( $tabs ) {
	$tabs['email'] = __( 'Email Settings', 'templatic-admin' );
	return $tabs;
}
/**
 * Create email setting data action.
 *
 * @param string $column 		Column.
 */
function registration_email_setting_data( $column ) {
	$tmpdata = get_option( 'templatic_settings' );
	switch ( $column ) {
		case 'email':
		?>

		<tr class="registration-email alternate">
			<td><label class="form-textfield-label"><?php echo esc_html__( 'Registration email to user', 'templatic-admin' ); ?></label></td>

			<td>
				<a href="javascript:void(0 );" onclick="open_quick_edit( 'registration-email', 'edit-registration-email' )"><?php echo esc_html__( 'Quick Edit', 'templatic-admin' );?></a>
				|
				<a href="javascript:void(0 );" onclick="reset_to_default( 'registration_success_email_subject', 'registration_success_email_content', 'registration-email' );"><?php echo esc_html__( 'Reset', 'templatic-admin' );?></a>
				<span class="spinner" style="margin:2px 18px 0;"></span>
				<span class="qucik_reset"><?php echo esc_html__( 'Data reset', 'templatic' );?></span>
			</td>
		</tr>
		<tr class="edit-registration-email alternate" style="display:none">
			<td width="100%" colspan="3">
				<h4 class="edit-sub-title">Quick Edit</h4>
				<table width="98%" align="left" class="tab-sub-table">
					<tr>
						<td style="line-height:10px">
							<label class="form-textfield-label sub-title"><?php echo esc_html__( 'Subject', 'templatic-admin' ); ?></label>
						</td>
						<td width="90%" style="line-height:10px">
							<input type="text" name="registration_success_email_subject" id="registration_success_email_subject" value="<?php if ( isset( $tmpdata['registration_success_email_subject'] ) ) {
								echo wp_kses_post( wp_unslash( $tmpdata['registration_success_email_subject'] ) ); } else {
									echo 'Thank you for registering!'; } ?>"/>
						</td>
					</tr>
					<tr>
						<td style="line-height:10px">
							<label class="form-textfield-label sub-title"><?php echo esc_html__( 'Message', 'templatic-admin' ); ?></label>
						</td>
						<td width="90%" style="line-height:10px">
							<?php
							$settings = array(
								'wpautop' => false,/* use wpautop?*/
								'media_buttons' => false,/* show insert/upload button(s)*/
								'textarea_name' => 'registration_success_email_content', /* set the textarea name to something different, square brackets [] can be used here*/
								'textarea_rows' => '7',/* rows="..."*/
								'tabindex' => '',
								'editor_css' => '<style>.wp-editor-wrap{width:640px;margin-left:0px;}</style>',/* intended for extra styles for both visual and HTML editors buttons, needs to include the <style> tags, can use "scoped".*/
								'editor_class' => '',/* add extra class(es) to the editor textarea*/
								'teeny' => true, /* output the minimal editor config used in Press This*/
								'dfw' => true, /* replace the default fullscreen with DFW (supported on the front-end in WordPress 3.4)*/
								'tinymce' => false, /* load TinyMCE, can be used to pass settings directly to TinyMCE using an array()*/
								'quicktags' => true, /* load Quicktags, can be used to pass settings directly to Quicktags using an array()*/
								);
							if ( '' != $tmpdata['registration_success_email_content'] ) {
								$content = stripslashes( $tmpdata['registration_success_email_content'] );
							} else {
									$content = __( '<p>Dear [#user_name#],</p><p>Thank you for registering and welcome to [#site_name#]. You can proceed with logging in to your account.</p><p>Login here: [#site_login_url_link#]</p><p>Username: [#user_login#]</p><p>Password: [#user_password#]</p><p>Feel free to change the password after you login for the first time.</p><p>&nbsp;</p><p>Thanks again for signing up at [#site_name#]</p>', 'templatic' );
							}
							wp_editor( $content, 'registration_success_email_content', $settings );
?>
</td>
</tr>
<tr>
	<td colspan="2">
		<div class="buttons">
			<div class="inline_update">
				<a class="button-primary save alignleft quick_save" href="javascript:void(0);" accesskey="s"><?php echo esc_html__( 'Save Changes', 'templatic-admin' );?></a>
				<a class="button-secondary cancel alignright " href="javascript:void(0);" onclick="open_quick_edit( 'edit-registration-email', 'registration-email' )" accesskey="c"><?php echo esc_html__( 'Cancel', 'templatic-admin' ); ?></a>
				<span class="save_error" style="display:none"></span><span class="spinner"></span>
			</div>
		</div>
	</td>
</tr>
</table>
</td>
</tr>
<tr class="admin-registration-email">
	<td><label class="form-textfield-label"><?php echo esc_html__( 'Registration email to admin', 'templatic-admin' ); ?></label></td>

	<td>
		<a href="javascript:void(0 );" onclick="open_quick_edit( 'admin-registration-email', 'edit-admin-registration-email' )"><?php echo esc_html__( 'Quick Edit', 'templatic-admin' );?></a>

		<a href="javascript:void(0 );" onclick="reset_to_default( 'admin_registration_success_email_subject', 'admin_registration_success_email_content', 'admin-registration-email' );"><?php echo esc_html__( 'Reset', 'templatic-admin' );?></a>
		<span class="spinner" style="margin:2px 18px 0;"></span>
		<span class="qucik_reset"><?php echo esc_html__( 'Data reset', 'templatic' );?></span>
	</td>
</tr>
<tr class="edit-admin-registration-email" style="display:none">
	<td width="100%" colspan="3">
		<h4 class="edit-sub-title">Quick Edit</h4>
		<table width="98%" align="left" class="tab-sub-table">
			<tr>
				<td style="line-height:10px">
					<label class="form-textfield-label sub-title"><?php echo esc_html__( 'Subject', 'templatic-admin' ); ?></label>
				</td>
				<td width="90%" style="line-height:10px">
					<input type="text" name="admin_registration_success_email_subject" id="admin_registration_success_email_subject" value="<?php if ( isset( $tmpdata['admin_registration_success_email_subject'] ) ) {
						echo wp_kses_post( wp_unslash( $tmpdata['admin_registration_success_email_subject'] ) ); } else {
							echo 'New user registration'; } ?>"/>
				</td>
			</tr>
			<tr>
				<td style="line-height:10px">
					<label class="form-textfield-label sub-title"><?php echo esc_html__( 'Message', 'templatic-admin' ); ?></label>
				</td>
				<td width="90%" style="line-height:10px">
					<?php
					$settings = array(
						'wpautop' => false,
						'media_buttons' => false,
						'textarea_name' => 'admin_registration_success_email_content',
						'textarea_rows' => '7',
						'tabindex' => '',
						'editor_css' => '<style>.wp-editor-wrap{width:640px;margin-left:0px;}</style>',
						'editor_class' => '',
						'teeny' => true,
						'dfw' => true,
						'tinymce' => false,
						'quicktags' => true,
						);
					if ( '' != $tmpdata['admin_registration_success_email_content'] ) {
						$content = stripslashes( $tmpdata['admin_registration_success_email_content'] );
					} else {
						$content = '<p>Dear admin,</p><p>A new user has registered on your site [#site_name#].</p><p>Login Credentials: [#site_login_url_link#]</p><p>Username: [#user_login#]</p><p>Password: [#user_password#]</p>';
					}
					wp_editor( $content, 'admin_registration_success_email_content', $settings );
					?>
				</td>
			</tr>
			<tr>
				<td colspan="2">
					<div class="buttons">
						<div class="inline_update">
							<a class="button-primary save alignleft quick_save" href="javascript:void(0 );" accesskey="s"><?php echo esc_html__( 'Save Changes', 'templatic-admin' );?></a>
							<a class="button-secondary cancel alignright " href="javascript:void(0 );" onclick="open_quick_edit( 'edit-admin-registration-email', 'admin-registration-email' )" accesskey="c"><?php echo esc_html__( 'Cancel', 'templatic-admin' );?></a>
							<span class="save_error" style="display:none"></span><span class="spinner"></span>
						</div>
					</div>
				</td>
			</tr>
		</table>
	</td>
</tr>
<?php
break;
	} // End switch().
}
/**
 * Create email setting data acti.
 *
 * @param string $column 	Add email column
 */
function legends_email_setting_data( $column ) {
	$tmpdata = get_option( 'templatic_settings' );
	switch ( $column ) {
		case 'email':
			echo '<div id="legend_notifications">' . wp_kses_post( wp_unslash( templatic_legend_notification() ) ) . '</div>';
		break;
	}
}

/**
 * This function will display the legends description on email settings page in general settings.
 */
function templatic_legend_notification() {
	$legend_display = '<div class="tevo_sub_title">' . __( 'Email shortcodes', 'templatic-admin' ) . ' </div>';
	$legend_display .= '<p class="tevolution_desc">' . __( 'Email shortcodes are essential variables to be used to display dynamic content. The <strong>Highlighted / Bold</strong> ones will work for all the available Email Templates. Shortcodes in the mail content can be repositioned or removed but the shortocdes other than Bold ones can only be added in their respective Email Templates. For examlple: The shortcodes with "user" as prefix are specifically available for Template to Users. ' ) . '</p>';
	$legend_display .= '<p style="line-height:30px;width:100%;"><label style="float:left;width:200px;"><strong>[#to_name#]</strong></label>' . __( 'Name of the recipient. ', 'templatic-admin' ) . '<br />
	<label style="float:left;width:200px;"><strong>[#site_name#]</strong></label>' . __( 'Site name as you provided in General Settings', 'templatic-admin' ) . '<br />
	<label style="float:left;width:200px;"><strong>[#admin_email#]</strong></label>' . __( 'Admin email', 'templatic-admin' ) . '<br />
	<label style="float:left;width:200px;"><strong>[#site_login_url#]</strong></label>' . __( 'Site\'s login page URL', 'templatic-admin' ) . '<br />
	<label style="float:left;width:200px;">[#user_login#]</label>' . __( 'The users username', 'templatic-admin' ) . '<br />
	<label style="float:left;width:200px;">[#user_email#]</label>' . __( 'The users email', 'templatic-admin' ) . '<br />
	<label style="float:left;width:200px;">[#user_password#]</label>' . __( 'User password', 'templatic-admin' ) . '<br />
	<label style="float:left;width:200px;"><strong>[#site_login_url_link#]</strong></label>' . __( 'Login page URL', 'templatic-admin' ) . '<br />
	<label style="float:left;width:200px;">[#post_link#]</label>' . __( 'Post permalink', 'templatic-admin' ) . '<br />
	<label style="float:left;width:200px;">[#post_title#]</label>' . __( 'Post Title', 'templatic-admin' ) . '<br />
	<label style="float:left;width:200px;">[#post_type#]</label>' . __( 'Post Type', 'templatic-admin' ) . '<br />
	<label style="float:left;width:200px;">[#post_date#]</label>' . __( 'Date of post', 'templatic-admin' ) . '<br />
	<label style="float:left;width:200px;">[#information_details#]</label>' . __( 'Details about the submitted post. ', 'templatic-admin' ) . '<br />
	<label style="float:left;width:200px;">[#transaction_details#]</label>' . __( 'Transaction details. ', 'templatic-admin' ) . '<br />
	<label style="float:left;width:200px;">[#frnd_subject#]</label>' . __( 'Subject fields for the "Send to friend" form', 'templatic-admin' ) . '<br />
	<label style="float:left;width:200px;">[#frnd_comments#]</label>' . __( '"Send to Friend" content', 'templatic-admin' ) . '<br />
	<label style="float:left;width:200px;">[#your_name#]</label>' . __( 'Sender\'s name', 'templatic-admin' ) . '<br />
	<label style="float:left;width:200px;">[#submited_information_link#]</label>' . __( 'URL of the detail page', 'templatic-admin' ) . '<br />
	<label style="float:left;width:200px;">[#payable_amt#]</label>' . __( 'Payable amount', 'templatic-admin' ) . '<br />
	<label style="float:left;width:200px;">[#bank_name#]</label>' . __( 'Bank name', 'templatic-admin' ) . '<br />
	<label style="float:left;width:200px;">[#account_number#]</label>' . __( 'Account number', 'templatic-admin' ) . '<br />
	<label style="float:left;width:200px;">[#submition_Id#]</label>' . __( 'Submission ID', 'templatic-admin' ) . '<br />
	<label style="float:left;width:200px;">[#transection_date#]</label>' . __( 'Payment date', 'templatic-admin' ) . '<br />
	<label style="float:left;width:200px;">[#transection_id#]</label>' . __( 'Transection ID', 'templatic-admin' ) . '<br />
	<label style="float:left;width:200px;">[#alivedays#]</label>' . __( 'Alive days', 'templatic-admin' ) . '<br />
	<label style="float:left;width:200px;">[#days_left#]</label>' . __( 'Number of days remaining', 'templatic-admin' ) . '</p><br />';

	return $legend_display;
}
/* eof - templatic legends */


/**
 * Create login. register and profile short code page
 */
function register_module_insert_page() {
	global $wpdb;
	/* Tevolution login page */
	$templatic_settings = get_option( 'templatic_settings' );
	$login_id = $wpdb->get_var( "SELECT ID FROM $wpdb->posts WHERE post_name = 'login'" );
	if ( '' == $login_id ) {
		$login_data = array(
			'post_status' 		=> 'publish',
			'post_type' 		=> 'page',
			'post_author' 		=> 1,
			'post_name' 		=> 'login',
			'post_title' 		=> 'Login',
			'post_content' 		=> '[tevolution_login][tevolution_register]',
			'post_parent' 		=> 0,
			'comment_status' 	=> 'closed',
			);
		$login_id = wp_insert_post( $login_data );
		update_post_meta( $login_id, '_wp_page_template', 'default' );

		$tmpdata['tevolution_login'] = $login_id;
		$templatic_settings = array_merge( $templatic_settings, $tmpdata );
		update_option( 'templatic_settings', $templatic_settings );
		update_option( 'tevolution_login', $login_id );

	} elseif ( is_plugin_active( 'sitepress-multilingual-cms/sitepress.php' ) && get_option( 'tmpl_wpml_register_custom_filed' ) == '' ) {
		global $sitepress;
		$current_lang_code = ICL_LANGUAGE_CODE;
		$default_language = $sitepress->get_default_language();
		/* Insert wpml icl_translations table*/
		$sitepress->set_element_language_details( $login_id, $el_type = 'post_page', $login_id, $current_lang_code, $default_language );
		if ( function_exists( 'wpml_insert_templ_post' ) ) {
			wpml_insert_templ_post( $login_id, 'page' ); /* insert post in language */
		}
	}
	/* Tevolution Register Page */
	$register_id = $wpdb->get_var( "SELECT ID FROM $wpdb->posts WHERE post_name = 'register'" );
	if ( '' == $register_id ) {
		$register_data = array(
			'post_status' 		=> 'publish',
			'post_type' 		=> 'page',
			'post_author' 		=> 1,
			'post_name' 		=> 'register',
			'post_title' 		=> 'Register',
			'post_content' 		=> '[tevolution_register]',
			'post_parent' 		=> 0,
			'comment_status' 	=> 'closed',
			);
		$register_id = wp_insert_post( $register_data );
		update_post_meta( $register_id, '_wp_page_template', 'default' );
		$tmpdata['tevolution_register'] = $register_id;
		$templatic_settings = array_merge( $templatic_settings, $tmpdata );
		update_option( 'templatic_settings', $templatic_settings );
		update_option( 'tevolution_register', $register_id );
	} elseif ( is_plugin_active( 'sitepress-multilingual-cms/sitepress.php' ) && get_option( 'tmpl_wpml_register_custom_filed' ) == '' ) {
		global $sitepress;
		$current_lang_code = ICL_LANGUAGE_CODE;
		$default_language = $sitepress->get_default_language();
		/* Insert wpml icl_translations table*/
		$sitepress->set_element_language_details( $register_id, $el_type = 'post_page', $register_id, $current_lang_code, $default_language );
		if ( function_exists( 'wpml_insert_templ_post' ) ) {
			wpml_insert_templ_post( $register_id, 'page' ); /* insert post in language */
		}
	}
	/* Tevolution Register Page */
	$profile_id = $wpdb->get_var( "SELECT ID FROM $wpdb->posts WHERE post_name = 'profile'" );
	if ( '' == $profile_id ) {
		$profile_data = array(
			'post_status' 		=> 'publish',
			'post_type' 		=> 'page',
			'post_author' 		=> 1,
			'post_name' 		=> 'profile',
			'post_title' 		=> 'Profile',
			'post_content' 		=> '[tevolution_profile]',
			'post_parent' 		=> 0,
			'comment_status' 	=> 'closed',
			);
		$profile_id = wp_insert_post( $profile_data );
		update_post_meta( $profile_id, '_wp_page_template', 'default' );
		$tmpdata['tevolution_profile'] = $profile_id;
		$templatic_settings = array_merge( $templatic_settings, $tmpdata );
		update_option( 'templatic_settings', $templatic_settings );
		update_option( 'tevolution_profile', $profile_id );
	} elseif ( is_plugin_active( 'sitepress-multilingual-cms/sitepress.php' ) && get_option( 'tmpl_wpml_register_custom_filed' ) == '' ) {
		global $sitepress;
		$current_lang_code = ICL_LANGUAGE_CODE;
		$default_language = $sitepress->get_default_language();
		/* Insert wpml icl_translations table*/
		$sitepress->set_element_language_details( $profile_id, $el_type = 'post_page', $profile_id, $current_lang_code, $default_language );
		if ( function_exists( 'wpml_insert_templ_post' ) ) {
			wpml_insert_templ_post( $profile_id, 'page' ); /* insert post in language */
		}
	}
	if ( is_plugin_active( 'sitepress-multilingual-cms/sitepress.php' ) && get_option( 'tmpl_wpml_register_custom_filed' ) == '' ) {
		update_option( 'tmpl_wpml_register_custom_filed', 'inserted' );
	}
}
/**
 * Registration form settings.
 *
 * @param string $column 		Add email column
 */
function templatic_general_setting_register_data( $column ) {
	$tmpdata = get_option( 'templatic_settings' );
	$logion_id = get_option( 'tevolution_login' );
	if ( @$logion_id != @$tmpdata['tevolution_login'] ) {
		update_option( 'tevolution_login', $tmpdata['tevolution_login'] );
	}

	$register_id = get_option( 'tevolution_register' );
	if ( @$tmpdata['tevolution_register'] != @$register_id ) {
		update_option( 'tevolution_register', $tmpdata['tevolution_register'] );
	}

	$profile_id = get_option( 'tevolution_profile' );
	if ( @$tmpdata['tevolution_profile'] != @$profile_id ) {
		update_option( 'tevolution_profile', $tmpdata['tevolution_profile'] );
	}
	?>
	<table id="registration_page_setup" class="tmpl-general-settings form-table">
		<tr>
			<td colspan="2"><p class="tevolution_desc"><?php echo sprintf( esc_html__( 'Match your Login, Register and Profile pages below to ensure registration works correctly. These pages were created automatically when Tevolution was activated. If you need to create them manually please open the %s', 'templatic-admin' ), '<a href="//templatic.com/docs/tevolution-guide/#registration" target= "_blank"> documentation guide</a>' )?></p></td>
		</tr>
		<tr>
			<th><label><?php echo esc_html__( 'Allow user to auto login after registration', 'templatic-admin' ); ?></label></th>
			<td>
				<div class="input-switch"><input type="checkbox" id="allow_autologin_after_reg" name="allow_autologin_after_reg" value="1" <?php if ( isset( $tmpdata['allow_autologin_after_reg'] ) && 1 == @$tmpdata['allow_autologin_after_reg'] ) {?>checked="checked"<?php }?> />
					<label for="allow_autologin_after_reg">&nbsp;<?php echo esc_html__( 'Enable', 'templatic-admin' );?></label></div>
					<p class="description"><?php echo esc_html__( 'Enabling this option will automatically show the user status as logged in after registering on your site. ', 'templatic-admin' ); ?></p>
				</td>
			</tr>
			<!-- HTML for social loggin -->
			<tr>
				<th><label><?php echo esc_html__( 'Allow user to login from social sites', 'templatic-admin' ); ?></label></th>
				<td>
					<div class="input_wrap"><label for="allow_facebook_login"><input type="checkbox" id="allow_facebook_login" name="allow_facebook_login" value="1" onclick="return show_social_login(this.id );" <?php if ( isset( $tmpdata['allow_facebook_login'] ) && 1 == @$tmpdata['allow_facebook_login'] ) {?>checked="checked"<?php }?> />&nbsp;<?php echo esc_html__( 'Facebook', 'templatic-admin' );?></label></div>
					<div id="show_facebook_key" <?php if ( ( ! isset( $tmpdata['allow_facebook_login'] ) && 1 != @$tmpdata['allow_facebook_login'] ) || '' == @$tmpdata['allow_facebook_login'] ) { ?> style="display:none;" <?php } ?>>
						<?php echo esc_html__( 'App ID', 'templatic-admin' ); ?>
						<input type="text" name="facebook_key" id="facebook_key" placeholder="<?php echo esc_html__( 'Your Facbook App ID here', 'templatic-admin' ); ?>" value="<?php if ( isset( $tmpdata['facebook_key'] ) ) {echo wp_kses_post( wp_unslash( $tmpdata['facebook_key'] ) );} ?>"/>
						<?php echo esc_html__( 'Secret Key', 'templatic-admin' ); ?>
						<input type="text" name="facebook_secret_key" id="facebook_secret_key" placeholder="<?php echo esc_html__( 'Your Facbook Secret Key here', 'templatic-admin' ); ?>" value="<?php if ( isset( $tmpdata['facebook_secret_key'] ) ) {echo wp_kses_post( wp_unslash( $tmpdata['facebook_secret_key'] ) );} ?>"/>
						<p class="description"><?php echo esc_html__( 'You can create the facebook key from', 'templatic-admin' ); ?><a href="https://developers.facebook.com/apps"><?php echo esc_html__( ' here', 'templatic-admin' ); ?></a></p>
					</div>
					<div class="input_wrap"><label for="allow_google_login"><input type="checkbox" id="allow_google_login" name="allow_google_login" value="1" onclick="return show_social_login(this.id );" <?php if ( isset( $tmpdata['allow_google_login'] ) && 1 == @$tmpdata['allow_google_login'] ) {?>checked="checked"<?php }?> />&nbsp;<?php echo esc_html__( 'Google', 'templatic-admin' );?></label></div>
					<div id="show_google_key" <?php if ( ( ! isset( $tmpdata['allow_google_login'] ) && 1 != @$tmpdata['allow_google_login'] ) || '' == @$tmpdata['allow_google_login'] ) { ?> style="display:none;" <?php } ?>>
						<?php echo esc_html__( 'App ID', 'templatic-admin' ); ?>
						<input type="text" name="google_key" id="google_key" placeholder="<?php echo esc_html__( 'Your google App ID here', 'templatic-admin' ); ?>" value="<?php if ( isset( $tmpdata['google_key'] ) ) {	echo wp_kses_post( wp_unslash( $tmpdata['google_key'] ) );} ?>"/>
						<?php echo esc_html__( 'Secret Key', 'templatic-admin' ); ?>
						<input type="text" name="google_secret_key" id="google_secret_key" placeholder="<?php echo esc_html__( 'Your Google Secret Key here', 'templatic-admin' ); ?>" value="<?php if ( isset( $tmpdata['google_secret_key'] ) ) {echo wp_kses_post( wp_unslash( $tmpdata['google_secret_key'] ) );} ?>"/>
						<p class="description"><?php echo esc_html__( 'You can create the google key from', 'templatic-admin' ); ?><a href="https://code.google.com/apis/console/"><?php echo esc_html__( ' here', 'templatic-admin' ); ?></a></p>
					</div>
					<div class="input_wrap"><label for="allow_twitter_login"><input type="checkbox" id="allow_twitter_login" name="allow_twitter_login" value="1" onclick="return show_social_login(this.id );" <?php if ( isset( $tmpdata['allow_twitter_login'] ) && 1 == $tmpdata['allow_twitter_login'] ) {?>checked="checked"<?php }?> />&nbsp;<?php echo esc_html__( 'Twitter', 'templatic-admin' );?></label></div>
					<div id="show_twitter_key" <?php if ( ( ! isset( $tmpdata['allow_twitter_login'] ) && 1 != @$tmpdata['allow_twitter_login'] ) || '' == @$tmpdata['allow_twitter_login'] ) { ?> style="display:none;" <?php } ?>>
						<?php echo esc_html__( 'App ID', 'templatic-admin' ); ?>
						<input type="text" placeholder="<?php echo esc_html__( 'Your Twitter App ID here', 'templatic-admin' ); ?>" name="twitter_key" id="twitter_key" value="<?php if ( isset( $tmpdata['twitter_key'] ) ) {echo wp_kses_post( wp_unslash( $tmpdata['twitter_key'] ) );} ?>"/>
						<?php echo esc_html__( 'Secret Key', 'templatic-admin' ); ?>
						<input type="text" name="twitter_secret_key" placeholder="<?php echo esc_html__( 'Your Twitter Secret Key here', 'templatic-admin' ); ?>" id="twitter_secret_key" value="<?php if ( isset( $tmpdata['twitter_secret_key'] ) ) {echo wp_kses_post( wp_unslash( $tmpdata['twitter_secret_key'] ) );} ?>"/>
						<p class="description"><?php echo esc_html__( 'You can create the twitter key from', 'templatic-admin' ); ?><a href="https://dev.twitter.com/apps/"><?php echo esc_html__( ' here', 'templatic-admin' ); ?></a></p>
					</div>
				</td>
			</tr>

			<tr>
				<th><label><?php echo esc_html__( 'Show Dashboard Bar', 'templatic-admin' ); ?></label></th>
				<td>
					<div class="input-switch"><input type="checkbox" id="show_dashboard_bar" name="show_dashboard_bar" value="1" <?php if ( isset( $tmpdata['show_dashboard_bar'] ) && 1 == @$tmpdata['show_dashboard_bar'] ) {?>checked="checked"<?php }?> />
						<label for="show_dashboard_bar">&nbsp;<?php echo esc_html__( 'Enable', 'templatic-admin' );?></label>
					</div>
					<p class="description"><?php echo esc_html__( 'Disabling this option will hide dashboard bar. ', 'templatic-admin' ); ?></p>
				</td>
			</tr>
			
			<?php if ( ! current_theme_supports( 'hide-primary-menu' ) ) { ?> 
				<tr>
					<th><label><?php echo esc_html__( 'Hide Login link from primary menu', 'templatic-admin' ); ?></label></th>
					<td>
						<div class="input-switch"><input type="checkbox" id="hide_login_link" name="hide_login_link" value="1" <?php if ( isset( $tmpdata['hide_login_link'] ) && 1 == @$tmpdata['hide_login_link'] ) {?>checked="checked"<?php }?> />
							<label for="hide_login_link">&nbsp;<?php echo esc_html__( 'Enable', 'templatic-admin' );?></label>
						</div>
						<p class="description"><?php echo esc_html__( 'Enable this option will hide login link from primary mennu. ', 'templatic-admin' ); ?></p>
					</td>
				</tr>
			<?php } ?>
			

				<tr>
					<td colspan="2">
						<p class="submit" style="clear: both;">
							<input type="submit" name="Submit" class="button button-primary button-hero" value="<?php echo esc_html__( 'Save All Settings', 'templatic-admin' );?>" />
							<input type="hidden" name="settings-submit" value="Y" />
						</p>
					</td>
				</tr>
			</table>
			<?php
			/*	 function to hide show the html of social login. */
			add_action( 'admin_footer', 'show_social_login' );
}

/**
 * Function to show particular social login key html.
 */
function show_social_login() {
			?>
			<script>function show_social_login(e ) {if ( e=="allow_facebook_login" ) {if ( jQuery("#"+e ).is( ':checked' ) ) {jQuery("#show_facebook_key" ).show();} else {jQuery("#show_facebook_key" ).hide();}}else if ( e=="allow_google_login" ) {if ( jQuery("#"+e ).is( ':checked' ) ) {jQuery("#show_google_key" ).show();} else {jQuery("#show_google_key" ).hide();}}else if ( e=="allow_twitter_login" ) {if ( jQuery("#"+e ).is( ':checked' ) ) {jQuery("#show_twitter_key" ).show();} else {jQuery("#show_twitter_key" ).hide();}}}</script><?php
}

/**
 * This function will add user custom fields on dashboard.
 */
add_action( 'show_user_profile', 'add_extra_profile_fields' );
/**
 * CALL A FUNCTION.
 *
 * @param array $user 		User Array.
 */
function add_extra_profile_fields( $user ) {
	$user_id = $user->ID;
	fetch_user_registration_fields( 'profile', $user_id ); /* CALL A FUNCTION TO DISPLAY CUSTOM FIELDS */
}
add_action( 'edit_user_profile', 'add_extra_profile_fields' );


/**
 * This function will save custom field data displaying on profile page in backend.
 */
add_action( 'personal_options_update', 'update_extra_profile_fields' );
add_action( 'edit_user_profile_update', 'update_extra_profile_fields' );
/**
 * CALL A FUNCTION.
 * update user data.
 *
 * @param integer $user_id 		User id.
 */
function update_extra_profile_fields( $user_id ) {
	global $form_fields_usermeta;
	fetch_user_custom_fields();

	foreach ( $form_fields_usermeta as $fkey => $fval ) {
		$fldkey = "$fkey";
		if ( isset( $_POST[ "$fkey" ] ) ) {
			$fldkey = wp_kses_post( wp_unslash( $_POST[ "$fkey" ] ) );
		}
		update_user_meta( $user_id, $fkey, $fldkey ); /* User Custom Metadata Here*/
	}

}
add_action( 'admin_footer', 'modify_form' );
/**
 * Add 'multipart/form-data' in edit profile page backend.
 */
function modify_form() {
	echo '<script type="text/javascript">
	jQuery("#your-profile" ).attr("enctype", "multipart/form-data" );
</script>
';
}

add_action( 'wp_ajax_user_customfield_sort', 'tevolution_user_customfield_sort' );
/**
 * Update user custom fields sorting options.
 */
function tevolution_user_customfield_sort() {
	$user_id = get_current_user_id();
	if ( isset( $_REQUEST['paging_input'] ) && 0 != $_REQUEST['paging_input'] && 1 != $_REQUEST['paging_input'] ) {
		$taxonomy_per_page = get_user_meta( $user_id, 'taxonomy_per_page', true );
		$j = wp_kses_post( wp_unslash( $_REQUEST['paging_input'] ) ) * $taxonomy_per_page + 1;
		$test = '';
		$i = $taxonomy_per_page;
		if ( isset( $_REQUEST['user_field_sort'] ) ) {
			$user_field_sort_count = count( wp_kses_post( wp_unslash( $_REQUEST['user_field_sort'] ) ) );
			for ( $j; $j >= $user_field_sort_count; $j-- ) {
				if ( '' != $_REQUEST['user_field_sort'][ $i ] ) {
					update_post_meta( intval( $_REQUEST['user_field_sort'][ $i ] ) , 'sort_order', $j );
				}
				$i--;
			}
		}
	} else {
		$j = 1;
		if ( isset( $_REQUEST['user_field_sort'] ) ) {
			$user_field_sort_count = count( wp_kses_post( wp_unslash( $_REQUEST['user_field_sort'] ) ) );
			for ( $i = 0; $i < $user_field_sort_count; $i++ ) {
				update_post_meta( intval( $_REQUEST['user_field_sort'][ $i ] ), 'sort_order', $j );
				$j++;
			}
		}
	}
	exit;
}

add_action( 'wp_ajax_nopriv_ajaxlogin', 'ajax_login' );
/**
 * Check user name and password while login from submit form.
 */
function ajax_login() {
	header( 'Content-Type: application/json; charset=utf-8' );
	/* First check the nonce, if it fails the function will break*/
	check_ajax_referer( 'ajax-login-nonce', 'security' );

	/* Nonce is checked, get the POST data and sign user on*/
	$info = array();
	if ( isset( $_REQUEST['username'] ) ) {
		$info['user_login'] = wp_kses_post( wp_unslash( $_POST['username'] ) );
	}
	if ( isset( $_REQUEST['password'] ) ) {
		$info['user_password'] = wp_kses_post( wp_unslash( $_POST['password'] ) );
	}
	$info['remember'] = true;

	$user_signon = wp_signon( $info, false );
	$package_selected = '';
	$package_type = '';
	if ( isset( $_REQUEST['pkg_id'] ) ) {
		$package_id = intval( $_POST['pkg_id'] );
	}
	if ( '' != $package_id ) {
		$selected_package_type = get_post_meta( $package_id, 'package_type', true );
		$subscription_as_pay_post = get_post_meta( $package_id, 'subscription_as_pay_post', true );
		if ( 1 == $subscription_as_pay_post ) {
			$_SESSION['custom_fields'] = $_POST;
		}
	}
	$package_selected = get_user_meta( $user_signon->data->ID, 'package_selected', true );
	$tmpdata = get_option( 'templatic_settings' );
	if ( @$package_selected ) {
		$package_type = get_post_meta( $package_selected, 'package_type', true );
	}
	$username = ucfirst( $user_signon->data->display_name );
	if ( is_wp_error( $user_signon ) ) {
		echo json_encode( array(
			'loggedin' => false,
			'message' => __( 'Wrong username or password. ', 'templatic' ),
			)
		);
	} else {
		echo json_encode( array(
			'loggedin' => true,
			'message' => sprintf( esc_html__( 'Welcome %s, submit your listing details. ', 'templatic' ), wp_kses_post( wp_unslash( $username ) ) ),
			'package_type' => $package_type,
			'selected_package_type' => $selected_package_type,
			)
		);
	}
	die();
}
