<?php
/**
 * Export Cities.
 *
 * @package WordPress
 * @subpackage Tevolution-LocationManager
 */

require( dirname( dirname( dirname( dirname( dirname( __FILE__ ) ) ) ) ) . '/wp-load.php' );

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

set_time_limit( 0 );
$file = dirname( __FILE__ );
if ( defined( 'WP_CONTENT_DIR' ) ) {
	$content_dir = explode( '/',WP_CONTENT_DIR );
	$file = substr( $file,0,stripos( $file, $content_dir[1] ) );
} else {
	$file = substr( $file,0,stripos( $file, 'wp-content' ) );
}

global $wpdb,$country_table,$zones_table,$multicity_table;
/*
*  Export multicity
*/
if ( isset( $_POST['export_city_csv'] ) && isset( $_POST['export_city'] ) && $_POST['export_city'] == '1' ) {
	$fname = 'cities_report_' . strtotime( date( 'Y-m-d' ) ) . '.csv';
	header( 'Content-Description: File Transfer' );
	header( 'Content-type: application/force-download' );
	header( 'Content-Disposition: inline; filename="' . $fname . '"' );
	ob_end_clean();
	ob_start();
	$f = fopen( 'php://output', 'w' ) or show_error( "Can't open php://output" );

	$city_info = $wpdb->get_results( "select * from $multicity_table order by city_id" );
	if ( $city_info ) {
		$is_zoom_cat = 0;
		$is_zoom_home = 0;

		echo wp_kses_post( $header_top = "City Id,Country Id,Zones Id,City Name,City Slug,Latitude,Longitude,Scall Factor,Is Zoom Home,Map Type,Post Type,Category ids,Is Default,Message,Color,Image,header color,Header image,Is Zoom Cat\r\n" );
		foreach ( $city_info as $city ) {
			if ( $city->is_zoom_home == 0 || $city->is_zoom_home == '' ) { 	 $is_zoom_home = 0;
			} else {	 $is_zoom_home = 1;	 }
			if ( $city->is_zoom_cat == 0 || $city->is_zoom_cat == '' ) { 	 $is_zoom_cat = 0 ;
			} else { $is_zoom_cat = 1; }

			$city_content = array( "$city->city_id","$city->country_id","$city->zones_id","$city->cityname","$city->city_slug","$city->lat","$city->lng","$city->scall_factor","$city->is_zoom_home","$city->map_type","$city->post_type","$city->categories","$city->is_default","$city->message","$city->color","$city->images","$city->header_color","$city->header_image","$is_zoom_cat" );

			if ( ! fputcsv( $f, $city_content ) ) {
				echo esc_html__( "Can't write line $n: $line", 'templatic-admin' );
			}
		}
		fclose( $f ) or show_error( "Can't close php://output" );
		$csvStr = ob_get_contents();
		ob_end_clean();
		print_r( $csvStr );

	} else {
		echo esc_html__( 'No record available','templatic-admin' );
	}
}// End if().
