<?php
/**
 * Check custom taxonomy module activate.
 *
 * @package Wordpress.
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

include( TEMPL_MONETIZE_FOLDER_PATH . 'templatic-custom_taxonomy/custom_post_type_lang.php' );
if (  ( ( isset( $_SERVER['REQUEST_URI'] ) && strstr( wp_kses_post( wp_unslash( $_SERVER['REQUEST_URI'] ) ), '/wp-admin/' ) ) || is_admin() )  && ! defined( 'DOING_AJAX' ) ) {
	include( TEMPL_MONETIZE_FOLDER_PATH . 'templatic-custom_taxonomy/taxonomy_admin.php' );
} else {
	include( TEMPL_MONETIZE_FOLDER_PATH . 'templatic-custom_taxonomy/taxonomy_functions.php' );
}
add_action( 'templ_add_admin_menu_', 'templ_add_submenu_taxonomy', 11 );
add_filter( 'set-screen-option', 'taxonomy_set_screen_option', 10, 3 );
add_action( 'init', 'create_post_type' ); /* create custom post type function */
add_action( 'init', 'create_custom_taxonomy' ); /* create custom post type taxonomy */
add_action( 'init', 'create_custom_tags' ); /* Create custom post type tags */

add_filter( 'templatic_general_settings_tab', 'tmpl_more_setting', 13 );
add_action( 'templatic_general_data_email', 'taxonomy_email_setting_data', 12 );
/**
 * Function for screen option.
 *
 * @param string $status 		Stauts.
 * @param string $option 		Option.
 * @param string $value 		Value.
 */
function taxonomy_set_screen_option( $status, $option, $value ) {
	if ( 'taxonomy_per_page' == $option ) {
		$user_id = get_current_user_id();

	if ( isset( $_REQUEST['wp_screen_options']['value'] ) && $_REQUEST['wp_screen_options']['value'] != 0 ) {
		update_user_meta( $user_id, 'taxonomy_per_page', $_REQUEST['wp_screen_options']['value']);
}

	}
}

/**
 * Coding to add sub menu under main menu.
 */
function templ_add_submenu_taxonomy() {
	$menu_title = esc_html__( 'Custom Fields', 'templatic-admin' );
	global $taxonomy_screen_option;

	$taxonomy_screen_option = add_submenu_page( 'templatic_system_menu', $menu_title, $menu_title, 'administrator', 'custom_setup', 'add_custom_taxonomy' );
	add_action( "load-$taxonomy_screen_option", 'taxonomy_screen_options' );
}

/**
 * Function for screen option.
 */
function taxonomy_screen_options() {
	global $taxonomy_screen_option;
	$screen = get_current_screen();
	/* get out of here if we are not on our settings page */
	if ( ! is_object( $screen ) || $screen->id != $taxonomy_screen_option ) {
		return;
	}

	$args = array(
		'label' => __( 'Per Page', 'templatic' ),
		'default' => 50,
		'option' => 'taxonomy_per_page',
		);
	add_screen_option( 'per_page', $args );
}


/**
 * This function adds a submenu page for creating or editing the taxonomies.
 */
function add_custom_taxonomy() {
	do_action( 'tmpl_custom_setup_tabs' );
	$tab = isset( $_REQUEST['ctab'] ) ? wp_kses_post( wp_unslash( $_REQUEST['ctab'] ) ) : '';
	switch ( $tab ) {
		case 'custom_setup':
			if ( ( isset( $_REQUEST['action'] ) && 'add_taxonomy' == $_REQUEST['action'] ) || ( isset( $_REQUEST['action'] ) && 'edit-type' == $_REQUEST['action']  ) ) {
				include( TEMPL_MONETIZE_FOLDER_PATH . 'templatic-custom_taxonomy/add_custom_taxonomy.php' );
			} else {
				include( TEMPL_MONETIZE_FOLDER_PATH . 'templatic-custom_taxonomy/manage_custom_taxonomy.php' );
			}
break;
		case '':

			if ( isset( $_REQUEST['action'] ) && 'addnew' == $_REQUEST['action'] ) {
				include( TEMPL_MONETIZE_FOLDER_PATH . 'templatic-custom_fields/admin_manage_custom_fields_edit.php' );
			} else {
				include( TEMPL_MONETIZE_FOLDER_PATH . 'templatic-custom_fields/admin_manage_custom_fields_list.php' );
			}
	break;
		case 'custom_fields':

			if ( isset( $_REQUEST['action'] ) && 'addnew' == $_REQUEST['action'] ) {
				include( TEMPL_MONETIZE_FOLDER_PATH . 'templatic-custom_fields/admin_manage_custom_fields_edit.php' );
			} else {
				include( TEMPL_MONETIZE_FOLDER_PATH . 'templatic-custom_fields/admin_manage_custom_fields_list.php' );
			}
	break;
		case 'user_custom_fields':
			if ( isset( $_REQUEST['action'] ) && 'addnew' == $_REQUEST['action'] ) {
				include( TEMPL_REGISTRATION_FOLDER_PATH . 'admin_custom_usermeta_edit.php' );
			} else {
				include( TEMPL_REGISTRATION_FOLDER_PATH . 'admin_custom_usermeta_list.php' );
			}
	break;
	}
}

/*
 *Add tabs in all section.
 */
add_action( 'tmpl_custom_setup_tabs', 'tmpl_custom_setup_tabs_fn' );
/**
 * Apply filter for get the general setting tabs
 * if you want to create new main tab in general setting menu then use 'templatic_general_settings_tab' filter hook and pass the tabs arrya in filter hook function and return tabs array.
 */
function tmpl_custom_setup_tabs_fn() {
	$tabs = array(
		'custom_fields' => __( 'Custom Fields', 'templatic-admin' ),
		'user_custom_fields' => __( 'User Profile Fields', 'templatic-admin' ),
		'custom_setup' => __( 'Post Types', 'templatic-admin' ),
		);
	@$tabs = apply_filters( 'templatic_custom_setup_tab', $tabs );
	echo '<div class="wrap"><div id="icon-options-general" class="icon32"><br></div>';
	?>
	<h2 class="nav-tab-wrapper">
		<?php
		$i = 0;
		foreach ( $tabs as $tab => $name ) {
			if ( 0 == $i ) {
				$tab_key = $tab;
			}

			$current_tab = isset( $_REQUEST['ctab'] ) ? wp_kses_post( wp_unslash( $_REQUEST['ctab'] ) ) : $tab_key;
			$class = ( $tab == $current_tab) ? ' nav-tab-active' : '';
			echo wp_kses_post( wp_unslash( "<a class='nav-tab$class' href='?page=custom_setup&ctab=$tab'>$name</a>" ) );
			$i++;
		}
		echo '</h2>';
}

	/* EOF - add submenu page for taxonomies */
if ( ( isset( $_REQUEST['page'] ) && 'delete-type' == $_REQUEST['page'] ) ) {
		$post_type = get_option( 'templatic_custom_post' );
		$taxonomy = get_option( 'templatic_custom_taxonomy' );
		$tag = get_option( 'templatic_custom_tags' );
		if ( isset( $_REQUEST['post-type'] ) ) {
			$taxonomy_slug = $post_type[ wp_kses_post( wp_unslash( $_REQUEST['post-type'] ) ) ]['slugs'][0];
			$tag_slug = $post_type[ wp_kses_post( wp_unslash( $_REQUEST['post-type'] ) ) ]['slugs'][1];
			unset( $post_type[ $_REQUEST['post-type'] ] );
		}
		unset( $taxonomy[ $taxonomy_slug ] );
		unset( $tag[ $tag_slug ] );
		update_option( 'templatic_custom_post', $post_type );
		update_option( 'templatic_custom_taxonomy', $taxonomy );
		update_option( 'templatic_custom_tags', $tag );
	if ( file_exists( get_template_directory() . '/taxonomy-' . $taxonomy_slug . '.php' ) ) {
		unlink( get_template_directory() . '/taxonomy-' . $taxonomy_slug . '.php' );
	}
	if ( file_exists( get_template_directory() . '/taxonomy-' . $tag_slug . '.php' ) ) {
		unlink( get_template_directory() . '/taxonomy-' . $tag_slug . '.php' );
	}
	if ( file_exists( get_template_directory() . '/single-' . wp_kses_post( wp_unslash( $_REQUEST['post-type'] ) ) . '.php' ) ) {
		unlink( get_template_directory() . '/single-' . wp_kses_post( wp_unslash( $_REQUEST['post-type'] ) ) . '.php' );
	}
		wp_redirect( admin_url( 'admin.php?page=custom_setup&ctab=custom_setup&custom_msg_type=delete' ) );
		exit;
}

	/**
	 * This function will load all the scripts.
	 */
function upload_admin_scripts() {
		wp_enqueue_script( 'media-upload' );
		wp_enqueue_script( 'thickbox' );
		wp_register_script( 'my-upload', __( plugin_dir_url( __FILE__ ), 'templatic' ) . '/upload-script.js', array( 'jquery', 'media-upload', 'thickbox' ) );
		wp_enqueue_script( 'my-upload' );
}

	/**
	 * EOF - load scripts.
	 * NAME : function to load the css.
	 * DESCRIPTION : this function will load all the css scripts.
	 */
function upload_admin_styles() {
	wp_enqueue_style( 'thickbox' );
}

/* EOF - load css */
if ( ( isset( $_REQUEST['action'] ) && 'add_taxonomy' == $_REQUEST['action'] ) || ( isset( $_REQUEST['action'] ) && 'edit-type' == $_REQUEST['action'] ) ) {
	add_action( 'admin_print_scripts', 'upload_admin_scripts' );
	add_action( 'admin_print_styles', 'upload_admin_styles' );
}



/**
 * Register all custom posts, taxonomies, tags from here>
 */
function create_post_type() {
	if ( function_exists( 'tevolution_thumbnail_width' ) && function_exists( 'tevolution_thumbnail_height' ) ) {

	add_image_size( 'tevolution_thumbnail', apply_filters( 'tevolution_thumbnail_width', 60 ), apply_filters( 'tevolution_thumbnail_height', 60 ), true );
	}
	$args = get_option( 'templatic_custom_post' );
	if ( $args ) :
		foreach ( $args as $key => $_args ) {
			/* menu string trnalation with wpml for custom post type */
			foreach ( $args[ $key ]['labels'] as $key1 => $_args1 ) {
				if ( function_exists( 'icl_t' ) ) {
					icl_register_string( 'templatic', $_args1, $_args1 );
					$_args1 = icl_t( 'templatic', $_args1, $_args1 );
				} else {
					$_args1 = @$_args1;
				}
				$args[ $key ]['labels'][ $key1 ] = $_args1;
			}
			register_post_type( $key, @$args[ $key ] );
		}
		if ( isset( $_REQUEST['post_type'] ) ) {
			$post_type = wp_kses_post( wp_unslash( $_REQUEST['post_type'] ) );
			if ( 'page' != $post_type && 'post' != $post_type && 'product' != $post_type && 'attachment' != $post_type && 'revision' != $post_type && 'nav_menu_item' != $post_type ) {
				if ( in_array( $post_type, tevolution_get_post_type() ) ) {
					add_filter( 'manage_edit-' . $post_type . '_columns', 'templatic_edit_taxonomy_columns', 10, 2 );
					add_action( 'manage_posts_custom_column', 'templatic_manage_taxonomy_columns', 10, 2 );
					add_filter( 'post_row_actions', 'templatic_extra_actions', 10, 2 );
				}
			}
		}
		endif;
}
/**
 * Function for screen option.
 *
 * @param string $actions 		Bulk action to perform.
 * @param array  $post 			Post Array.
 */
function templatic_extra_actions( $actions, $post ) {
		global $wpdb;
		$transaction_table = $wpdb->prefix . 'transactions';
		$sql = "select trans_id from $transaction_table where 1=1 and post_id='" . $post->ID . "' AND (package_type is NULL OR package_type=0 ) order by trans_id DESC LIMIT 1";
		$trans_id = $wpdb->get_results( $sql );
	if ( ! empty( $trans_id ) && $trans_id[0]->trans_id ) {
			$actions['tran_id'] = esc_html__( 'Transaction ID:', 'templatic' ) . ' <a href="' . site_url() . '/wp-admin/admin.php?page=transcation&action=edit&trans_id=' . $trans_id[0]->trans_id . '">' . $trans_id[0]->trans_id . '</a>';
	}
		return $actions;
}

/**
 * NAME : create_custom_taxonomy
 * DESCRIPTION : Create custom taxonomy , Move taxonomies and detail page files in template directory.
 */
function create_custom_taxonomy() {
	$args = get_option( 'templatic_custom_taxonomy' );
	$args1 = get_option( 'templatic_custom_post' );
	if ( $args ) :
		foreach ( $args as $key => $_args ) {
			if ( post_type_exists( $_args['post_slug'] ) ) {
				register_taxonomy( $_args['labels']['singular_name'], array( @$_args['post_slug'] ), $args[ $key ] );
				$_name = @$args1[ $_args['post_slug'] ]['labels']['name'];

				if ( ! in_array( $_args['post_slug'], array( 'listing', 'event' ) ) ) {
					register_sidebars( 1, array(
						'id' => 'after_' . $_args['labels']['singular_name'] . '_header',
						'name' => sprintf( __( '%s Category Pages - Below Header', 'templatic' ), ucfirst( $_name ) ),
						'description' => sprintf( __( 'Widgets placed here appear on the %s category page below the header part, ( design supported after tevolution 2.2 )', 'templatic' ), $_name ),
						'before_widget' => '<div id="%1$s" class="widget %2$s">',
						'after_widget' => '</div>',
						'before_title' => '<h3 class="widget-title">',
						'after_title' => '</h3>',
						)
					);
				}
				/* Listing page Sider bar */
				register_sidebars( 1, array(
					'id' => '' . $_args['labels']['singular_name'] . '_listing_sidebar',
					'name' => apply_filters( 'listing_page_sidebar_title',
						sprintf( __( '%s Category Page Sidebar', 'templatic' ),
							ucfirst( $_name ) ), $_name ), 'description' => sprintf( __( 'Display widgets in a sidebar on %s category pages. ', 'templatic' ), $_name ),
					'before_widget' => '<div id="%1$s" class="widget %2$s">',
					'after_widget' => '</div>',
					'before_title' => '<h3 class="widget-title">',
					'after_title' => '</h3>',
					)
				);

				/* Single post Type sider bar */
				register_sidebars( 1, array(
					'id' => '' . $_args['post_slug'] . '_detail_sidebar',
					'name' => sprintf( __( '%s Detail Page Sidebar', 'templatic' ), ucfirst( $_name ) ),
					'description' => sprintf( __( 'Display widgets in a sidebar on single %s pages. ', 'templatic' ), $_name ),
					'before_widget' => '<div id="%1$s" class="widget %2$s">',
					'after_widget' => '</div>',
					'before_title' => '<h3 class="widget-title">',
					'after_title' => '</h3>',
					)
				);

				/* Single post Type sider bar */
				register_sidebars( 1, array(
					'id' => '' . $_args['post_slug'] . '_above_mobile_listing',
					'name' => sprintf( __( '%s Category Mobile Header', 'templatic' ), ucfirst( $_name ) ),
					'description' => sprintf( __( 'Display widgets %s above pages. ', 'templatic' ), $_name ),
					'before_widget' => '<div id="%1$s" class="widget %2$s">',
					'after_widget' => '</div>',
					'before_title' => '<h3 class="widget-title">',
					'after_title' => '</h3>',
					)
				);

				/* Add post submit side bar */
				register_sidebars( 1, array(
					'id' => 'add_' . $_args['post_slug'] . '_submit_sidebar',
					'name' => sprintf( __( 'Submit %s - Sidebar', 'templatic' ), ucfirst( $_name ) ),
					'description' => sprintf( __( 'Display widgets in a sidebar that appears on %s submission pages. ', 'templatic' ), $_name ),
					'before_widget' => '<div id="%1$s" class="widget %2$s">',
					'after_widget' => '</div>',
					'before_title' => '<h3 class="widget-title">',
					'after_title' => '</h3>',
					)
				);

				/* Add sidebar for listing page below header */



				$taxonomy = $_args['labels']['singular_name'];
				/* DEFINE TAXONOMY. */
				/**
				 * CODE TO CALL THE FUNCTIONS WHICH MANAGE THE PRICE FIELD IN CATEGORIES.
				 */
				if ( isset( $taxonomy ) && $taxonomy == $_args['labels']['singular_name'] ) {
					add_action( $taxonomy . '_edit_form_fields', 'category_custom_fields_Edit' );
					add_action( $taxonomy . '_add_form_fields', 'category_custom_fields_AddField' );
					add_action( 'edited_term', 'category_custom_fields_AlterField' );
					add_action( 'created_' . $taxonomy, 'category_custom_fields_AlterField' );
					/* FILTERS TO MANAGE PRICE COLUMNS */
					add_filter( 'manage_edit-' . $taxonomy . '_columns', 'edit_price_cat_column' );
					add_filter( 'manage_' . $taxonomy . '_custom_column', 'tmpl_manage_price_cat_col', 10, 3 );
				}
			} // End if().
		} // End foreach().
		endif;
}
/**
 * Create custom tags.
 */
	function create_custom_tags() {
		$args = get_option( 'templatic_custom_tags' );
		$args1 = get_option( 'templatic_custom_post' );
	if ( $args ) :
		foreach ( $args as $key => $_args ) {
				register_taxonomy( $_args['labels']['singular_name'], @$_args['post_slug'], $args[ $key ] );
		}
			endif;
}

/**
 * NAME : templatic_edit_taxonomy_columns.
 * DESCRIPTION : Return the columns name for backend listing.
 *
 * @param var $columns columns.
 */
function templatic_edit_taxonomy_columns( $columns ) {
	global $wpdb, $post;
	$post1 = $post;
	if( isset( $_REQUEST['post_type'] ) ) {
		$post_type = wp_kses_post( wp_unslash( $_REQUEST['post_type'] ) );
	}
	wp_reset_query();
	$cus_post_type = get_post_meta( $post_id, 'template_post_type', true );
	remove_all_actions( 'posts_where' );

	/* code to fetch the columns from custom fields */
	$args = array(
		'post_type' => 'custom_fields',
		'posts_per_page' => -1,
		'post_status' => array( 'publish' ),
		'meta_query' => array(
			'relation' => 'AND',
			array(
				'key' => 'post_type_' . $post_type . '',
				'value' => array( 'all', $post_type ),
				'compare' => 'IN',
				'type' => 'text',
				),
			array(
				'key' => 'show_in_column',
				'value' => 1,
				'compare' => '=',
				),
			array(
				'key' => 'is_active',
				'value' => 1,
				'compare' => '=',
				)
			),
		'meta_key' => 'sort_order',
		'orderby' => 'meta_value_num',
		'meta_value_num' => 'sort_order',
		'order' => 'ASC',
		);
	$fld_meta_info = null;
	add_filter( 'posts_join', 'custom_field_posts_where_filter' );
	$fld_meta_info = new WP_Query( $args );
	remove_filter( 'posts_join', 'custom_field_posts_where_filter' );


	/* Re-arrange the custom post type columns field */


	$columns1['cb'] = '<input type="checkbox" />';
	$columns1['title'] = esc_html__( 'Title', 'templatic' );
	$columns1['post_image'] = esc_html__( 'Image', 'templatic' );

	if ( is_plugin_active( 'sitepress-multilingual-cms/sitepress.php' ) ) {
		if ( function_exists( 'icl_get_languages' ) ) {
			$languages = icl_get_languages( 'skip_missing=0' );
		}
		if ( ! empty( $languages ) ) {
			foreach ( $languages as $l ) {
				if ( ! $l['active'] ) {
					echo '<a href="' . esc_url( $l['url'] ) . '">';
				}
				if ( ! $l['active'] ) {
					$country_flag .= '<img src="' . esc_url ( $l['country_flag_url'] ) . '" height="12" alt="' . esc_attr( $l['language_code'] ) . '" width="18" />' . ' ';
				}
				if ( ! $l['active'] ) {
					echo '</a>';
				}
			}
		}
		$columns1['icl_translations'] = $country_flag;
	}



	$columns1['categories_'] = esc_html__( 'Categories', 'templatic' );
	$columns1['author'] = esc_html__( 'Author', 'templatic' );

	$fld_columns = array();
	if ( $fld_meta_info->have_posts() ) {
		while ( $fld_meta_info->have_posts() ) : $fld_meta_info->the_post();

			if ( '' != $post->post_title ) {
				$columns1[ get_post_meta($post->ID,'htmlvar_name',true) ] = apply_filters( 'tmpl_column_title', $post->post_title );
			}
		endwhile;
		wp_reset_query();
	}

	$post = $post1;
	/* Add apply filters tevolution_manage_edit columns before price package date and status */
	$columns1 = apply_filters( 'tevolution_manage_edit-' . $post_type . '_columns', $columns1 );


	$columns1['price_package'] = esc_html__( 'Price package', 'templatic' );
	$columns1['posted_on'] = esc_html__( 'Date', 'templatic' );
	$columns1['tran_status'] = esc_html__( 'Transaction Status', 'templatic' );
	$columns = array_merge( $columns1, $fld_columns );

	return apply_filters( 'tevolution_change_edit-' . $post_type . '_columns', $columns );
}

/**
 * END OF FUNCTION.
 * Return the value for specific column.
 *
 * @param var $column column.
 * @param int $post_id post_id.
 */
function templatic_manage_taxonomy_columns( $column, $post_id ) {
	global $post, $monetization, $wpdb;
	$post = get_post( $post_id );
	if ( isset( $_REQUEST['post_ID'] ) ) {
		$post_id = wp_kses_post( wp_unslash( $_REQUEST['post_ID'] ) );
	}
	$taxonomy = '';
	if ( isset( $_REQUEST['post_type'] ) ) {
		$post_type = wp_kses_post( wp_unslash( $_REQUEST['post_type'] ) );
	}
	$custom_post_types_args = array();
	$custom_post_types = get_post_types( $custom_post_types_args, 'objects' );
	if ( $custom_post_types ) {
		foreach ( $custom_post_types as $content_type ) {

			if ( $content_type->name == $post_type ) {
				$taxonomy = @$content_type->slugs[0];
				$tags = @$content_type->slugs[1];
				break;
			}
		}
	}
	switch ( $column ) {
		case 'post_image' :
			/* get logo url */
			$logo_url = get_post_meta( $post->ID, 'listing_logo', true );

			/* tevolution_thumbnail */
			if ( $post->post_parent ) {
				$post_id = $post->post_parent;
			} else {
				$post_id = $post->ID;
			}
			if ( has_post_thumbnail() ) :
				$post_image = wp_get_attachment_image_src( get_post_thumbnail_id( $post_id ), 'tevolution_thumbnail' );
			echo '<a href="' . esc_url( site_url() ) . '/wp-admin/post.php?post=' . intval( $post_id ) . '&action=edit">';
			echo '<img src="' . esc_url( $post_image[0] ) . '" width="60" height="60">';
				echo '</a>';
			elseif ( '' != $logo_url ) :
				echo '<a href="' . esc_url( site_url() ) . '/wp-admin/post.php?post=' . intval( $post_id ) . '&action=edit">';
			?>
			<img src="<?php echo esc_url( $logo_url ); ?>" width="80px" width="60" height="60"/>
			<?php
			echo '</a>';
			else :
				if ( function_exists( 'bdw_get_images_plugin' ) ) {
					$post_image = bdw_get_images_plugin( $post_id, 'tevolution_thumbnail' );
					$post_image = ( @$post_image[0]['file'] ) ? @$post_image[0]['file'] : plugin_dir_url( __FILE__ ) . 'images/noimage-150x150.jpg';
				}
			echo '<a href="' . esc_url( site_url() ) . '/wp-admin/post.php?post=' . intval( $post_id ) . '&action=edit">';
			echo '<img src="' . esc_url( $post_image ) . '" width="60" height="60">';
			echo '</a>';
			endif;
			break;

		case 'tran_status' :
			$package_id = get_post_meta( $post_id, 'package_select', true );
			if ( '' != $package_id ) {
				if ( $post->post_parent ) {
					$post_id = $post->post_parent;
				} else {
					$post_id = $post->ID;
				}
				$transaction_table = $wpdb->prefix . 'transactions';
				$sql = "select trans_id from $transaction_table t where 1=1 and post_id='" . $post_id . "' AND (package_type is NULL OR package_type=0 ) order by t.trans_id DESC";
				$trans_id = $wpdb->get_results( $sql );
				if ( ! empty( $trans_id ) && $trans_id[0]->trans_id ) {
					echo wp_kses_post( wp_unslash( tmpl_get_transaction_status( $trans_id[0]->trans_id, $post_id ) ) );
				} else {
					echo wp_kses_post( wp_unslash( tmpl_get_transaction_status( 0, $post_id ) ) );
				}
			} else {
				echo '-';
			}

			break;
		case 'categories_' :
			/* Get the post_category for the post. */

			$templ_events = get_the_terms( $post_id, $taxonomy );
			if ( is_array( $templ_events ) ) {
				foreach ( $templ_events as $key => $templ_event ) {
					$edit_link = site_url() . '/wp-admin/edit.php?' . $taxonomy . '=' . $templ_event->slug . '&post_type=' . $post_type;
					$templ_events[ $key ] = '<a href="' . $edit_link . '">' . $templ_event->name . '</a>';
				}
				echo wp_kses_post( wp_unslash( implode( ', ', $templ_events ) ) );
			} else {
				esc_html_e( 'Uncategorized', 'templatic' );
			}
			break;

		case 'tags_' :
			/* Get the post_tags for the post. */

			$templ_event_tags = get_the_terms( $post_id, $tags );
			if ( is_array( $templ_event_tags ) ) {
				foreach ( $templ_event_tags as $key => $templ_event_tag ) {
					$edit_link = site_url() . '/wp-admin/edit.php?' . $tags . '=' . $templ_event_tag->slug . '&post_type=' . $post_type;
					$templ_event_tags[ $key ] = '<a href="' . $edit_link . '">' . $templ_event_tag->name . '</a>';
				}
				echo wp_kses_post( wp_unslash( implode( ', ', $templ_event_tags ) ) );
			} else {
				esc_html_e( 'No Tags', 'templatic' );
			}

			break;

		case 'posted_on' :
			/* Get the post_tags for the post. */
			if ( $post->post_date ) {
				$date_format = get_option( 'date_format' );
				$time_format = get_option( 'time_format' );
				$date = strtotime( get_the_time( 'Y-m-d H:i', $post_id ) );
				echo wp_kses_post( wp_unslash( date_i18n( $date_format . ', ' . $time_format, $date ) ) );
			} else {
				echo wp_kses_post( wp_unslash( date_i18n( get_option( 'date_format' ) . ' ' . get_option( 'time_format' ), strtotime( date( 'F j, Y, g:i a' ) ) ) ) );
			}

			break;
			case 'price_package' :

			if ( $post->post_parent )
				$post_id = $post->post_parent;
			else
				$post_id = $post->ID;

			$trans_post = $post;
			$transactions = $wpdb->prefix . "transactions";
			$trans_object = $wpdb->get_row( "select * from $transactions as t where 1=1 AND (package_type is NULL OR package_type=0 ) AND post_id = {$post_id} order by t.trans_id desc LIMIT 0,1 " );
			$package_id = get_post_meta( $post_id, 'package_select', true );
			if ( $package_id != "" ) {
				$package_name = get_the_title( $package_id );
				if ( function_exists( 'fetch_currency_with_position' ) ) {
					if ( @$trans_object->payable_amt == '' )
					{
						$paid_amount = fetch_currency_with_position( get_post_meta( $post_id, 'paid_amount', true ) );
					}
					else
					{
						$paid_amount = display_amount_with_currency_plugin( $trans_object->payable_amt);
					}
				}
				$transaction_db_table_name = $wpdb->prefix . 'transactions';
				$trans_date = $wpdb->get_var( "select payment_date from $transaction_db_table_name t where post_id = '" . $post_id . "' AND (package_type is NULL OR package_type=0 ) order by t.trans_id DESC" ); /* change it to calculate expired day as per transactions */
				if ( !isset( $trans_date ) )
					$trans_date = get_the_date( 'Y-m-d', $post_id );
				$transaction_price_pkg = $monetization->templ_get_price_info( $package_id, '' );

				$publish_date = date_i18n( 'Y-m-d', strtotime( $trans_date ) );
				$alive_days = $transaction_price_pkg[0]['alive_days'];
				$expired_date = date_i18n( get_option( "date_format" ), strtotime( $publish_date . "+$alive_days day" ) );


				$featured_text = '-';
				/* Check for featured posts: start */
				$featured_type = get_post_meta( $post_id, 'featured_type', true );
				if ( 'h' == $featured_type ) {
					$featured_text = esc_html__( "Home", 'templatic-admin' );
				} elseif ( 'c' == $featured_type ) {
					$featured_text = esc_html__( "Category", 'templatic-admin' );
				} elseif ( 'both' == $featured_type ) {
					$featured_text = esc_html__( "Home, Category", 'templatic-admin' );
				}
				echo '<p>' . esc_html__( 'Package Name: ', 'templatic-admin' ) . '<a href="' . esc_url( site_url() ) . '/wp-admin/admin.php?page=monetization&action=edit&package_id=' . intval( $package_id ) . '&tab=packages" >' . wp_kses_post( wp_unslash( $package_name ) ). '</a></p>';

				$package_amount = fetch_currency_with_position( get_post_meta( $package_id, 'package_amount', true ) );
				$paid_amount = fetch_currency_with_position( get_post_meta( $post_id, 'paid_amount', true ) );
				echo '<p>' . esc_html__( 'Total Price: ', 'templatic-admin' ) . wp_kses_post( wp_unslash( $paid_amount ) ) . '</p>';

				if ( $featured_text != '-' ) {
					echo '<p>' . esc_html__( 'Featured: ', 'templatic-admin' ) . wp_kses_post( wp_unslash( $featured_text ) ) . '</p>';
				}
				if ( $expired_date ) {
					echo '<p>' . esc_html__( 'Exp Date: ', 'templatic-admin' ) . wp_kses_post( wp_unslash( $expired_date ) ) . '</p>';
				}
			} else {
				echo '-';
			} // End if().
			$post = $trans_post;
			break;
			case $column :
			if ( get_post_meta( $post_id, $column, true ) ) {
				$value = apply_filters( 'tevolution_posts_custom_column', get_post_meta( $post_id, $column, true ), $column);
				if ( is_array( $value ) ) {
					echo wp_kses_post( wp_unslash( implode( ', ', $value ) ) );
				} else {
					echo wp_kses_post( wp_unslash( apply_filters( 'tmpl_column_value', $value, $column) ) );
				}
			} else {
				echo "";
			}

			/* Just break out of the switch statement for everything else. */
			default :
			break;
		} // End switch().
	}

	/* EOF - FETCH DATA IN BACK END */




/*
NAME : ADD THE CATEGORY PRICE
ARGUMENTS : TAXONOMY NAME
DESCRIPTION : THIS FUNCTIONS IS USED TO ADD THE PRICE FIELD IN CATEGORY
*/

function category_custom_fields_AddField( $tax ) {
	add_category_price_field( $tax, 'add' );
}

/* EOF - ADD CATEGORY PRICE */
/* NAME : FUNCTION TO ADD/EDIT CATEGORY PRICE FIELD
ARGUMENTS : TAXONOMY NAME, OPERATION
DESCRIPTION : THIS FUNCTION ADDS/EDITS THE CATEGORY PRICE FIELD IN BACK END */

function add_category_price_field( $tax, $screen ) {
	if ( ( isset( $tax->taxonomy) && $tax->taxonomy != '' ) || ( isset( $tax->term_price ) && $tax->term_price != '' ) ) {
		$taxonomy = $tax->taxonomy;
		$term_price = $tax->term_price;
	}
	$currency_symbol = get_option( 'currency_symbol' );
	?>
	<tr class="form-field">
		<th scope="row" valign="top"><label for="cat_price"><?php
			echo esc_html__( "Category Price", 'templatic' );
			echo ' ( ' . wp_kses_post( wp_unslash( $currency_symbol ) ) . ' )'
			?></label></th>
			<td><input type="text" name="cat_price" id="cat_price" value="<?php
				if ( isset( $term_price ) && $term_price != '' ) {
					echo wp_kses_post( wp_unslash( $term_price ) );
				}
				?>" size="20"/>
				<p class="description"><?php echo sprintf( __( 'To change currency <a href="%sadmin.php?page=monetization&tab=currency_settings" target= "_blank" >click here</a>', 'templatic' ), esc_url( admin_url() ) ); ?>.</p>
			</td>
		</tr>
		<?php
	}

	/* EOF - ADD/EDIT CATEGORY PRICE FIELD */

	/* this functions is used to edit the price field in category */

	function category_custom_fields_Edit( $tax ) {
		add_category_price_field( $tax, 'edit' );
	}

	/* eof - edit category price */

	/* this functions is used to edit the price field in category */

	function category_custom_fields_AlterField( $termId ) {
		global $wpdb;
		$term_table = $wpdb->prefix . "terms";
		if ( isset( $_REQUEST['cat_price'] ) ) {
			$cat_price = wp_kses_post( wp_unslash( $_POST['cat_price'] ) );
		}
		if ( @$cat_price == '' ) {
			$cat_price = 0;
		}
		if ( @$cat_price != '' || @$cat_price == 0 ) {
			$sql = "update $term_table set term_price=" . $cat_price . " where term_id=" . $termId;
			$wpdb->query( $sql );
		}
	}

	/* eof - edit category price */

	/* this function adds a column in category table */

	function edit_price_cat_column( $columns ) {
		$args = get_option( 'templatic_custom_post' );
		foreach ( $args as $key => $val ) {
			$taxonomy = $val['label'];
			$posts = $val['labels']['name'];
			$columns = array(
				'cb' => '<input type="checkbox" />',
				'name' => __( 'Name', 'templatic' ),
				'price' => __( 'Price', 'templatic' ),
				'description' => __( 'Description', 'templatic' ),
				'slug' => __( 'Slug', 'templatic' ),
				'posts' => __( 'Posts', 'templatic' )
				);
		}
		return $columns;
	}


	add_action( 'quick_edit_custom_box', 'category_price_show', 10, 2 );
	/**
	 * Quick edit code start.
	 *
	 * @param string $col 			Column name.
	 * @param string $type 			Post Type.
	 */
	function category_price_show( $col, $type ) {
		if ( $type == 'event' )
			return;

		switch ( $col ) {
			case 'price':
			?>
			<fieldset>
				<div class="inline-edit-col">
					<label for="category_price">
						<span class="title"><?php esc_html_e( 'Price', DOAMIN); ?></span>
						<span class="input-text-wrap">
							<input class="category_price" type="text" name="cat_price" value="" size="10" />
						</span>
					</label>
				</div>
			</fieldset>
			<?php
			break;
		}
	}

	/* Quick edit code end */
	/* EOF - ADD COLUMN */

	/* To display the price in categories section in admin panel */

	function tmpl_manage_price_cat_col( $out, $column_name, $cat_id ) {
		global $wpdb;
		$term_table = $wpdb->prefix . "terms";
		$sql = "select * from $term_table where term_id=" . $cat_id;
		$term = $wpdb->get_results( $sql );
		switch ( $column_name ) {
			case 'price':
			$currency_symbol = get_option( 'currency_symbol' );
			$symbol_position = get_option( 'currency_pos' );
			if ( isset( $term[0]->term_price ) && $term[0]->term_price > 0 ) {
				$price = display_amount_with_currency_plugin( $term[0]->term_price );
			} else {
				$price = 0;
			}
			$out = $price;
			break;
		}

		return $out;
	}

	/* eof - display price */



/*
* Add Filter for create the general setting sub tab for email setting
*/

function tmpl_more_setting( $tabs ) {

	$tabs['email'] = esc_html__( 'Email Settings & Notifications', 'templatic-admin' );
	$tabs['custom_permalink'] = esc_html__( 'Permalink Settings', 'templatic-admin' );
	return $tabs;
}

/**
 * Create email setting data action.
 *
 * @param string $column 		Climn name email settings.
 */
function taxonomy_email_setting_data( $column ) {
	$tmpdata = get_option( 'templatic_settings' );
	switch ( $column ) {
		case 'email':
		?>
		<tr class="post-submission">
			<td><label for="package_type" class="form-textfield-label"><?php echo esc_html__( 'Submission notification to admin', 'templatic-admin' ); ?></label></td>
			<td>
				<a href="javascript:void( 0 );" onclick="open_quick_edit( 'post-submission', 'edit-post-submission' )"><?php echo esc_html__( "Quick Edit", 'templatic-admin' ); ?></a>
				|
				<a href="javascript:void( 0 );" onclick="reset_to_default( 'post_submited_success_email_subject', 'post_submited_success_email_content', 'post-submission' );"><?php echo esc_html__( "Reset", 'templatic-admin' ); ?></a>
				<span class="spinner" style="margin:0 18px 0;"></span>
				<span class="qucik_reset"><?php echo esc_html__( "Data reset", 'templatic-admin' ); ?></span>
			</td>
		</tr>
		<tr class="edit-post-submission" style="display:none">
			<td width="100%" colspan="3">
				<h4 class="edit-sub-title">Quick Edit</h4>
				<table width="98%" class="tab-sub-table" align="left">
					<tr>
						<td style="line-height:10px">
							<label class="form-textfield-label sub-title"><?php echo esc_html__( 'Subject', 'templatic-admin' ); ?></label>
						</td>
						<td width="90%" style="line-height:10px">
							<input type="text" name="post_submited_success_email_subject" id="post_submited_success_email_subject" value="<?php
							if ( isset( $tmpdata['post_submited_success_email_subject'] ) ) {
								echo wp_kses_post( wp_unslash( stripslashes( $tmpdata['post_submited_success_email_subject'] ) ) );
							} else {
								esc_html_e( 'A new post has been submitted on your site', 'templatic-admin' );
							}
							?>"/>
						</td>
					</tr>
					<tr>
						<td style="line-height:10px">
							<label class="form-textfield-label sub-title"><?php echo esc_html__( 'Message', 'templatic' ); ?></label>
						</td>
						<td width="90%" style="line-height:10px">
							<?php
							$settings = array(
								'wpautop' => false, /* use wpautop? */
								'media_buttons' => false, /* show insert/upload button(s ) */
								'textarea_name' => 'post_submited_success_email_content', /* set the textarea name to something different, square brackets [] can be used here */
								'textarea_rows' => '7', /* rows="..." */
								'tabindex' => '',
								'editor_css' => '<style>.wp-editor-wrap{width:640px;margin-left:0px;}</style>', /* intended for extra styles for both visual and HTML editors buttons, needs to include the <style> tags, can use "scoped". */
								'editor_class' => '', /* add extra class(es ) to the editor textarea */
								'teeny' => true, /* output the minimal editor config used in Press This */
								'dfw' => true, /* replace the default fullscreen with DFW (supported on the front-end in WordPress 3.4) */
								'tinymce' => false, /* load TinyMCE, can be used to pass settings directly to TinyMCE using an array() */
								'quicktags' => true /* load Quicktags, can be used to pass settings directly to Quicktags using an array() */
								);
							if ( $tmpdata['post_submited_success_email_content'] != "" ) {
								$content = stripslashes( $tmpdata['post_submited_success_email_content'] );
							} else {
								$content = esc_html__( '<p>Dear [#to_name#],</p><p>A new submission has been made on your site with the details below.</p><p>[#information_details#]</p><p>Thank You,<br/>[#site_name#]</p>', 'templatic' );
							}
							wp_editor( $content, 'post_submited_success_email_content', $settings );
							?>
						</td>
					</tr>
					<tr>
						<td colspan="2">
							<div class="buttons">
								<div class="inline_update">
									<a class="button-primary save quick_save" href="javascript:void( 0 );" accesskey="s"><?php echo esc_html__( "Save Changes", 'templatic' ); ?></a>
									<a class="button-secondary cancel" href="javascript:void( 0 );" onclick="open_quick_edit( 'edit-post-submission', 'post-submission' )" accesskey="c">Cancel</a>
									<span class="save_error" style="display:none"></span><span class="spinner"></span>
								</div>
							</div>
						</td>
					</tr>
				</table>
			</td>
		</tr>
		<tr class="user-post-submission alternate">
			<td><label for="package_type" class="form-textfield-label"><?php echo esc_html__( 'Submission notification to user', 'templatic-admin' ); ?></label></td>
			<td>
				<a href="javascript:void( 0 );" onclick="open_quick_edit( 'user-post-submission', 'user-edit-post-submission' )"><?php echo esc_html__( "Quick Edit", 'templatic-admin' ); ?></a>
				|
				<a href="javascript:void( 0 );" onclick="reset_to_default( 'user_post_submited_success_email_subject', 'user_post_submited_success_email_content', 'user-post-submission' );"><?php echo esc_html__( "Reset", 'templatic-admin' ); ?></a>
				<span class="spinner" style="margin:0 18px 0;"></span>
				<span class="qucik_reset"><?php echo esc_html__( "Data reset", 'templatic-admin' ); ?></span>
			</td>
		</tr>
		<tr class="user-edit-post-submission alternate" style="display:none">
			<td width="100%" colspan="3">
				<h4 class="edit-sub-title">Quick Edit</h4>
				<table width="98%" class="tab-sub-table" align="left">
					<tr>
						<td style="line-height:10px">
							<label class="form-textfield-label sub-title"><?php echo esc_html__( 'Subject', 'templatic-admin' ); ?></label>
						</td>
						<td width="90%" style="line-height:10px">
							<input type="text" name="user_post_submited_success_email_subject" id="user_post_submited_success_email_subject" value="<?php
							if ( isset( $tmpdata['user_post_submited_success_email_subject'] ) ) {
								echo wp_kses_post( wp_unslash( stripslashes( $tmpdata['user_post_submited_success_email_subject'] ) ) );
							} else {
								esc_html_e( 'Details about the listing you have submitted on [#site_title#]', 'templatic-admin' );
							}
							?>"/>
						</td>
					</tr>
					<tr>
						<td style="line-height:10px">
							<label class="form-textfield-label sub-title"><?php echo esc_html__( 'Message', 'templatic' ); ?></label>
						</td>
						<td width="90%" style="line-height:10px">
							<?php
							$settings = array(
								'wpautop' => false, /* use wpautop? */
								'media_buttons' => false, /* show insert/upload button(s ) */
								'textarea_name' => 'user_post_submited_success_email_content', /* set the textarea name to something different, square brackets [] can be used here */
								'textarea_rows' => '7', /* rows="..." */
								'tabindex' => '',
								'editor_css' => '<style>.wp-editor-wrap{width:640px;margin-left:0px;}</style>', /* intended for extra styles for both visual and HTML editors buttons, needs to include the <style> tags, can use "scoped". */
								'editor_class' => '', /* add extra class(es ) to the editor textarea */
								'teeny' => true, /* output the minimal editor config used in Press This */
								'dfw' => true, /* replace the default fullscreen with DFW (supported on the front-end in WordPress 3.4) */
								'tinymce' => false, /* load TinyMCE, can be used to pass settings directly to TinyMCE using an array() */
								'quicktags' => true /* load Quicktags, can be used to pass settings directly to Quicktags using an array() */
								);
							if ( $tmpdata['user_post_submited_success_email_content'] != "" ) {
								$content = stripslashes( $tmpdata['user_post_submited_success_email_content'] );
							} else {
								$content = esc_html__( '<p>Howdy [#to_name#],</p><p>You have submitted a new listing. Here are some details about it</p><p>[#information_details#]</p><p>Thank You,<br/>[#site_name#]</p>', 'templatic' );
							}
							wp_editor( $content, 'user_post_submited_success_email_content', $settings );
							?>
						</td>
					</tr>
					<tr>
						<td colspan="2">
							<div class="buttons">
								<div class="inline_update">
									<a class="button-primary save quick_save" href="javascript:void( 0 );" accesskey="s"><?php echo esc_html__( "Save Changes", 'templatic' ); ?></a>
									<a class="button-secondary cancel" href="javascript:void( 0 );" onclick="open_quick_edit( 'user-edit-post-submission', 'user-post-submission' )" accesskey="c">Cancel</a>
									<span class="save_error" style="display:none"></span><span class="spinner"></span>
								</div>
							</div>
						</td>
					</tr>
				</table>
			</td>
		</tr>
		<tr class="payment-success-client">
			<td><label class="form-textfield-label"><?php echo esc_html__( ' Successful payment notification to user', 'templatic' ); ?></label></td>

			<td>
				<a href="javascript:void( 0 );" onclick="open_quick_edit( 'payment-success-client', 'edit-payment-success-client' )"><?php echo esc_html__( "Quick Edit", 'templatic' ); ?></a>
				|
				<a href="javascript:void( 0 );" onclick="reset_to_default( 'payment_success_email_subject_to_client', 'payment_success_email_content_to_client', 'payment-success-client' );"><?php echo esc_html__( "Reset", 'templatic' ); ?></a>
				<span class="spinner" style="margin:0 18px 0;"></span>
				<span class="qucik_reset"><?php echo esc_html__( "Data reset", 'templatic' ); ?></span>
			</td>
		</tr>
		<tr class="edit-payment-success-client alternate" style="display:none">
			<td width="100%" colspan="2">
				<h4 class="edit-sub-title">Quick Edit</h4>
				<table width="98%" align="left" class="tab-sub-table">
					<tr>
						<td style="line-height:10px">
							<label class="form-textfield-label sub-title"><?php echo esc_html__( 'Subject', 'templatic' ); ?></label>
						</td>
						<td width="90%" style="line-height:10px">
							<input type="text" name="payment_success_email_subject_to_client" id="payment_success_email_subject_to_client" value="<?php
							if ( isset( $tmpdata['payment_success_email_subject_to_client'] ) ) {
								echo wp_kses_post( wp_unslash( $tmpdata['payment_success_email_subject_to_client'] ) );
							} else {
								echo esc_html__( 'Thank you for your submission!', 'templatic' );
							}
							?>"/>
						</td>
					</tr>
					<tr>
						<td style="line-height:10px">
							<label class="form-textfield-label sub-title"><?php echo esc_html__( 'Message', 'templatic' ); ?></label>
						</td>
						<td width="90%" style="line-height:10px">
							<?php
							$settings = array(
								'wpautop' => false, /* use wpautop? */
								'media_buttons' => false, /* show insert/upload button(s ) */
								'textarea_name' => 'payment_success_email_content_to_client', /* set the textarea name to something different, square brackets [] can be used here */
								'textarea_rows' => '7', /* rows="..." */
								'tabindex' => '',
								'editor_css' => '<style>.wp-editor-wrap{width:640px;margin-left:0px;}</style>', /* intended for extra styles for both visual and HTML editors buttons, needs to include the <style> tags, can use "scoped". */
								'editor_class' => '', /* add extra class(es ) to the editor textarea */
								'teeny' => true, /* output the minimal editor config used in Press This */
								'dfw' => true, /* replace the default fullscreen with DFW (supported on the front-end in WordPress 3.4) */
								'tinymce' => false, /* load TinyMCE, can be used to pass settings directly to TinyMCE using an array() */
								'quicktags' => true /* load Quicktags, can be used to pass settings directly to Quicktags using an array() */
								);
							if ( $tmpdata['payment_success_email_content_to_client'] != "" ) {
								$content = stripslashes( $tmpdata['payment_success_email_content_to_client'] );
							} else {
								$content = esc_html__( "<p>Hello [#to_name#],</p><p>Your submission has been approved! You can see the listing here:</p><p>[#transaction_details#]</p><p>If you'll have any questions about this please send an email to [#admin_email#]</p><p>Thanks!,<br/>[#site_name#]</p>", 'templatic' );
							}
							wp_editor( $content, 'payment_success_email_content_to_client', $settings );
							?>
						</td>
					</tr>
					<tr>
						<td colspan="2">
							<div class="buttons">
								<div class="inline_update">

									<a class="button-primary save alignleft quick_save" href="javascript:void( 0 );" accesskey="s"><?php echo esc_html__( "Save Changes", 'templatic' ); ?></a>
									<a class="button-secondary cancel alignright" href="javascript:void( 0 );" onclick="open_quick_edit( 'edit-payment-success-client', 'payment-success-client' )" accesskey="c">Cancel</a>
									<span class="save_error" style="display:none"></span><span class="spinner"></span>
								</div>
							</div>
						</td>
					</tr>
				</table>
			</td>
		</tr>
		<tr class="payment-success-admin alternate">
			<td><label class="form-textfield-label"><?php echo esc_html__( 'Successful payment notification for membership package to admin notification', 'templatic' ); ?></label></td>

			<td>
				<a href="javascript:void( 0 );" onclick="open_quick_edit( 'payment-success-admin', 'edit-payment-success-admin' )"><?php echo esc_html__( "Quick Edit", 'templatic' ); ?></a>
				|
				<a href="javascript:void( 0 );" onclick="reset_to_default( 'payment_success_email_subject_to_admin', 'payment_success_email_content_to_admin', 'payment-success-admin' );"><?php echo esc_html__( "Reset", 'templatic' ); ?></a>
				<span class="spinner" style="margin:0 18px 0;"></span>
				<span class="qucik_reset"><?php echo esc_html__( "Data reset", 'templatic' ); ?></span>
			</td>
		</tr>
		<tr class="edit-payment-success-admin alternate" style="display:none">
			<td width="100%" colspan="2">
				<h4 class="edit-sub-title">Quick Edit</h4>
				<table width="98%" align="left" class="tab-sub-table">
					<tr>
						<td style="line-height:10px">
							<label class="form-textfield-label sub-title"><?php echo esc_html__( 'Subject', 'templatic-admin' ); ?></label>
						</td>
						<td width="90%" style="line-height:10px">
							<input type="text" name="payment_success_email_subject_to_admin" id="payment_success_email_subject_to_admin" value="<?php
							if ( isset( $tmpdata['payment_success_email_subject_to_admin'] ) ) {
								echo wp_kses_post( wp_unslash( $tmpdata['payment_success_email_subject_to_admin'] ) );
							} else {
								echo esc_html__( 'You have received a payment', 'templatic' );
							}
							?>"/>
						</td>
					</tr>
					<tr>
						<td style="line-height:10px">
							<label class="form-textfield-label sub-title"><?php echo esc_html__( 'Message', 'templatic-admin' ); ?></label>
						</td>
						<td width="90%" style="line-height:10px">
							<?php
							$settings = array(
								'wpautop' => false, /* use wpautop? */
								'media_buttons' => false, /* show insert/upload button(s ) */
								'textarea_name' => 'payment_success_email_content_to_admin', /* set the textarea name to something different, square brackets [] can be used here */
								'textarea_rows' => '7', /* rows="..." */
								'tabindex' => '',
								'editor_css' => '<style>.wp-editor-wrap{width:640px;margin-left:0px;}</style>', /* intended for extra styles for both visual and HTML editors buttons, needs to include the <style> tags, can use "scoped". */
								'editor_class' => '', /* add extra class(es ) to the editor textarea */
								'teeny' => true, /* output the minimal editor config used in Press This */
								'dfw' => true, /* replace the default fullscreen with DFW (supported on the front-end in WordPress 3.4) */
								'tinymce' => false, /* load TinyMCE, can be used to pass settings directly to TinyMCE using an array() */
								'quicktags' => true /* load Quicktags, can be used to pass settings directly to Quicktags using an array() */
								);
							if ( $tmpdata['payment_success_email_content_to_admin'] != "" ) {
								$content = stripslashes( $tmpdata['payment_success_email_content_to_admin'] );
							} else {
								$content = esc_html__( "<p>Howdy [#to_name#],</p><p>You have received a payment of [#payable_amt#] on [#site_name#]. Details are available below</p><p>[#transaction_details#]</p><p>Thanks,<br/>[#site_name#]</p>", 'templatic' );
							}
							wp_editor( $content, 'payment_success_email_content_to_admin', $settings );
							?>
						</td>
					</tr>
					<tr>
						<td colspan="2">
							<div class="buttons">
								<div class="inline_update">
									<a class="button-primary save alignleft quick_save" href="javascript:void( 0 );" accesskey="s"><?php echo esc_html__( "Save Changes", 'templatic-admin' ); ?></a>
									<a class="button-secondary cancel alignright" href="javascript:void( 0 );" onclick="open_quick_edit( 'edit-payment-success-admin', 'payment-success-admin' )" accesskey="c">Cancel</a>
									<span class="save_error" style="display:none"></span><span class="spinner"></span>
								</div>
							</div>
						</td>
					</tr>
				</table>
			</td>
		</tr>


		<tr class="pre-payment-success-admin">
			<td><label class="form-textfield-label"><?php echo esc_html__( 'PreBank transfer notification to admin', 'templatic-admin' ); ?></label></td>

			<td>
				<a href="javascript:void( 0 );" onclick="open_quick_edit( 'pre-payment-success-admin', 'edit-pre-payment-success-admin' )"><?php echo esc_html__( "Quick Edit", 'templatic-admin' ); ?></a>
				|
				<a href="javascript:void( 0 );" onclick="reset_to_default( 'pre_payment_success_email_subject_to_admin', 'pre_payment_success_email_content_to_admin', 'pre-payment-success-admin' );"><?php echo esc_html__( "Reset", 'templatic' ); ?></a>
				<span class="spinner" style="margin:0 18px 0;"></span>
				<span class="qucik_reset"><?php echo esc_html__( "Data reset", 'templatic-admin' ); ?></span>
			</td>
		</tr>
		<tr class="edit-pre-payment-success-admin" style="display:none">
			<td width="100%" colspan="2">
				<h4 class="edit-sub-title">Quick Edit</h4>
				<table width="98%" align="left" class="tab-sub-table">
					<tr>
						<td style="line-height:10px">
							<label class="form-textfield-label sub-title"><?php echo esc_html__( 'Subject', 'templatic-admin' ); ?></label>
						</td>
						<td width="90%" style="line-height:10px">
							<input type="text" name="pre_payment_success_email_subject_to_admin" id="pre_payment_success_email_subject_to_admin" value="<?php
							if ( isset( $tmpdata['pre_payment_success_email_subject_to_admin'] ) ) {
								echo wp_kses_post( wp_unslash( $tmpdata['pre_payment_success_email_subject_to_admin'] ) );
							} else {
								esc_html_e( 'Submission pending payment', 'templatic' );
							}
							?>"/>
						</td>
					</tr>
					<tr>
						<td style="line-height:10px">
							<label class="form-textfield-label sub-title"><?php echo esc_html__( 'Message', 'templatic-admin' ); ?></label>
						</td>
						<td width="90%" style="line-height:10px">
							<?php
							$settings = array(
								'wpautop' => false, /* use wpautop? */
								'media_buttons' => false, /* show insert/upload button(s ) */
								'textarea_name' => 'pre_payment_success_email_content_to_admin', /* set the textarea name to something different, square brackets [] can be used here */
								'textarea_rows' => '7', /* rows="..." */
								'tabindex' => '',
								'editor_css' => '<style>.wp-editor-wrap{width:640px;margin-left:0px;}</style>', /* intended for extra styles for both visual and HTML editors buttons, needs to include the <style> tags, can use "scoped". */
								'editor_class' => '', /* add extra class(es ) to the editor textarea */
								'teeny' => true, /* output the minimal editor config used in Press This */
								'dfw' => true, /* replace the default fullscreen with DFW (supported on the front-end in WordPress 3.4) */
								'tinymce' => false, /* load TinyMCE, can be used to pass settings directly to TinyMCE using an array() */
								'quicktags' => true /* load Quicktags, can be used to pass settings directly to Quicktags using an array() */
								);
							if ( $tmpdata['pre_payment_success_email_content_to_admin'] != "" ) {
								$content = stripslashes( $tmpdata['pre_payment_success_email_content_to_admin'] );
							} else {
								$content = esc_html__( "<p>Dear [#to_name#],</p><p>A payment from username [#user_login#] is now pending on a submission or subscription to one of your plans.</p><p>[#transaction_details#]</p><p>Thanks!<br/>[#site_name#]</p>", 'templatic-admin' );
							}
							wp_editor( $content, 'pre_payment_success_email_content_to_admin', $settings );
							?>
						</td>
					</tr>
					<tr>
						<td colspan="2">
							<div class="buttons">
								<div class="inline_update">
									<a class="button-primary save alignleft quick_save" href="javascript:void( 0 );" accesskey="s"><?php echo esc_html__( "Save Changes", 'templatic-admin' ); ?></a>
									<a class="button-secondary cancel alignright" href="javascript:void( 0 );" onclick="open_quick_edit( 'edit-pre-payment-success-admin', 'pre-payment-success-admin' )" accesskey="c"><?php echo esc_html__( "Cancel", 'templatic-admin' ); ?></a>
									<span class="save_error" style="display:none"></span><span class="spinner"></span>
								</div>
							</div>
						</td>
					</tr>
				</table>
			</td>
		</tr>



		<tr class="pre-payment-success-user">
			<td><label class="form-textfield-label"><?php echo esc_html__( 'PreBank transfer notification to user', 'templatic-admin' ); ?></label></td>

			<td>
				<a href="javascript:void( 0 );" onclick="open_quick_edit( 'pre-payment-success-user', 'edit-pre-payment-success-user' )"><?php echo esc_html__( "Quick Edit", 'templatic-admin' ); ?></a>
				|
				<a href="javascript:void( 0 );" onclick="reset_to_default( 'pre_payment_success_email_subject_to_user', 'pre_payment_success_email_content_to_user', 'pre-payment-success-user' );"><?php echo esc_html__( "Reset", 'templatic' ); ?></a>
				<span class="spinner" style="margin:0 18px 0;"></span>
				<span class="qucik_reset"><?php echo esc_html__( "Data reset", 'templatic-admin' ); ?></span>
			</td>
		</tr>
		<tr class="edit-pre-payment-success-user" style="display:none">
			<td width="100%" colspan="2">
				<h4 class="edit-sub-title">Quick Edit</h4>
				<table width="98%" align="left" class="tab-sub-table">
					<tr>
						<td style="line-height:10px">
							<label class="form-textfield-label sub-title"><?php echo esc_html__( 'Subject', 'templatic-admin' ); ?></label>
						</td>
						<td width="90%" style="line-height:10px">
							<input type="text" name="pre_payment_success_email_subject_to_user" id="pre_payment_success_email_subject_to_user" value="<?php
							if ( isset( $tmpdata['pre_payment_success_email_subject_to_user'] ) ) {
								echo wp_kses_post( wp_unslash( $tmpdata['pre_payment_success_email_subject_to_user'] ) );
							} else {
								esc_html_e( 'Submission pending payment', 'templatic' );
							}
							?>"/>
						</td>
					</tr>
					<tr>
						<td style="line-height:10px">
							<label class="form-textfield-label sub-title"><?php echo esc_html__( 'Message', 'templatic-admin' ); ?></label>
						</td>
						<td width="90%" style="line-height:10px">
							<?php
							$settings = array(
								'wpautop' => false, /* use wpautop? */
								'media_buttons' => false, /* show insert/upload button(s ) */
								'textarea_name' => 'pre_payment_success_email_content_to_user', /* set the textarea name to something different, square brackets [] can be used here */
								'textarea_rows' => '7', /* rows="..." */
								'tabindex' => '',
								'editor_css' => '<style>.wp-editor-wrap{width:640px;margin-left:0px;}</style>', /* intended for extra styles for both visual and HTML editors buttons, needs to include the <style> tags, can use "scoped". */
								'editor_class' => '', /* add extra class(es ) to the editor textarea */
								'teeny' => true, /* output the minimal editor config used in Press This */
								'dfw' => true, /* replace the default fullscreen with DFW (supported on the front-end in WordPress 3.4) */
								'tinymce' => false, /* load TinyMCE, can be used to pass settings directly to TinyMCE using an array() */
								'quicktags' => true /* load Quicktags, can be used to pass settings directly to Quicktags using an array() */
								);
							if ( $tmpdata['pre_payment_success_email_content_to_user'] != "" ) {
								$content = stripslashes( $tmpdata['pre_payment_success_email_content_to_user'] );
							} else {
								$content = esc_html__( "<p>Dear [#to_name#],</p><p>A payment from username [#user_login#] is now pending on a submission or subscription to one of your plans.</p><p>[#transaction_details#]</p><p>Thanks!<br/>[#site_name#]</p>", 'templatic-admin' );
							}
							wp_editor( $content, 'pre_payment_success_email_content_to_user', $settings );
							?>
						</td>
					</tr>
					<tr>
						<td colspan="2">
							<div class="buttons">
								<div class="inline_update">
									<a class="button-primary save alignleft quick_save" href="javascript:void( 0 );" accesskey="s"><?php echo esc_html__( "Save Changes", 'templatic-admin' ); ?></a>
									<a class="button-secondary cancel alignright" href="javascript:void( 0 );" onclick="open_quick_edit( 'edit-pre-payment-success-user', 'pre-payment-success-user' )" accesskey="c"><?php echo esc_html__( "Cancel", 'templatic-admin' ); ?></a>
									<span class="save_error" style="display:none"></span><span class="spinner"></span>
								</div>
							</div>
						</td>
					</tr>
				</table>
			</td>
		</tr>



		<tr class="contact-us alternate">
			<td><label class="form-textfield-label"><?php echo esc_html__( 'Contact us form message', 'templatic-admin' ); ?></label></td>

			<td>
				<a href="javascript:void( 0 );" onclick="open_quick_edit( 'contact-us', 'edit-contact-us' )"><?php echo esc_html__( "Quick Edit", 'templatic-admin' ); ?></a>
				|
				<a href="javascript:void( 0 );" onclick="reset_to_default( 'contact_us_email_content', 'contact_us_email_content', 'contact-us' );"><?php echo esc_html__( "Reset", 'templatic' ); ?></a>
				<span class="spinner" style="margin:0 18px 0;"></span>
				<span class="qucik_reset"><?php echo esc_html__( "Data reset", 'templatic-admin' ); ?></span>
			</td>
		</tr>
		<tr class="edit-contact-us" style="display:none">
			<td width="100%" colspan="2">
				<h4 class="edit-sub-title">Quick Edit</h4>
				<table width="98%" align="left" class="tab-sub-table">

					<tr>
						<td style="line-height:10px">
							<label class="form-textfield-label sub-title"><?php echo esc_html__( 'Message', 'templatic-admin' ); ?></label>
						</td>
						<td width="90%" style="line-height:10px">
							<?php
							$settings = array(
								'wpautop' => false, /* use wpautop? */
								'media_buttons' => false, /* show insert/upload button(s ) */
								'textarea_name' => 'contact_us_email_content', /* set the textarea name to something different, square brackets [] can be used here */
								'textarea_rows' => '7', /* rows="..." */
								'tabindex' => '',
								'editor_css' => '<style>.wp-editor-wrap{width:640px;margin-left:0px;}</style>', /* intended for extra styles for both visual and HTML editors buttons, needs to include the <style> tags, can use "scoped". */
								'editor_class' => '', /* add extra class(es ) to the editor textarea */
								'teeny' => true, /* output the minimal editor config used in Press This */
								'dfw' => true, /* replace the default fullscreen with DFW (supported on the front-end in WordPress 3.4) */
								'tinymce' => false, /* load TinyMCE, can be used to pass settings directly to TinyMCE using an array() */
								'quicktags' => true /* load Quicktags, can be used to pass settings directly to Quicktags using an array() */
								);
							if ( $tmpdata['contact_us_email_content'] != "" ) {
								$content = stripslashes( $tmpdata['contact_us_email_content'] );
							} else {
								$content = esc_html__( "<p>Dear [#to_name#] ,</p><p>You have an inquiry message. Here are the details</p><p> Name: [#user_name#] </p> <p> Email: [#user_email#] </p> <p> Message: [#user_message#] </p>", 'templatic-admin' );
							}
							wp_editor( $content, 'contact_us_email_content', $settings );
							?>
						</td>
					</tr>
					<tr>
						<td colspan="2">
							<div class="buttons">
								<div class="inline_update">
									<a class="button-primary save alignleft quick_save" href="javascript:void( 0 );" accesskey="s"><?php echo esc_html__( "Save Changes", 'templatic-admin' ); ?></a>
									<a class="button-secondary cancel alignright" href="javascript:void( 0 );" onclick="open_quick_edit( 'edit-contact-us', 'contact-us' )" accesskey="c"><?php echo esc_html__( "Cancel", 'templatic-admin' ); ?></a>
									<span class="save_error" style="display:none"></span><span class="spinner"></span>
								</div>
							</div>
						</td>
					</tr>
				</table>
			</td>
		</tr>

		<tr class="admin-post-upgrade">
			<td><label class="form-textfield-label"><?php echo esc_html__( 'Post upgrade notification to admin', 'templatic-admin' ); ?></label></td>

			<td>
				<a href="javascript:void( 0 );" onclick="open_quick_edit( 'admin-post-upgrade', 'edit-admin-post-upgrade' )"><?php echo esc_html__( "Quick Edit", 'templatic-admin' ); ?></a>
				|
				<a href="javascript:void( 0 );" onclick="reset_to_default( 'admin_post_upgrade_email_subject', 'admin_post_upgrade_email_content', 'admin-post-upgrade' );"><?php echo esc_html__( "Reset", 'templatic' ); ?></a>
				<span class="spinner" style="margin:0 18px 0;"></span>
				<span class="qucik_reset"><?php echo esc_html__( "Data reset", 'templatic-admin' ); ?></span>
			</td>
		</tr>
		<tr class="edit-admin-post-upgrade" style="display:none">
			<td width="100%" colspan="2">
				<h4 class="edit-sub-title">Quick Edit</h4>
				<table width="98%" align="left" class="tab-sub-table">
					<tr>
						<td style="line-height:10px">
							<label class="form-textfield-label sub-title"><?php echo esc_html__( 'Subject', 'templatic-admin' ); ?></label>
						</td>
						<td width="90%" style="line-height:10px">
							<input type="text" name="admin_post_upgrade_email_subject" id="admin_post_upgrade_email_subject" value="<?php
							if ( isset( $tmpdata['admin_post_upgrade_email_subject'] ) ) {
								echo wp_kses_post( wp_unslash( $tmpdata['admin_post_upgrade_email_subject'] ) );
							} else {
								esc_html_e( 'A New Upgrade Request', 'templatic' );
							}
							?>"/>
						</td>
					</tr>
					<tr>
						<td style="line-height:10px">
							<label class="form-textfield-label sub-title"><?php echo esc_html__( 'Message', 'templatic-admin' ); ?></label>
						</td>
						<td width="90%" style="line-height:10px">
							<?php
							$settings = array(
								'wpautop' => false, /* use wpautop? */
								'media_buttons' => false, /* show insert/upload button(s ) */
								'textarea_name' => 'admin_post_upgrade_email_content', /* set the textarea name to something different, square brackets [] can be used here */
								'textarea_rows' => '7', /* rows="..." */
								'tabindex' => '',
								'editor_css' => '<style>.wp-editor-wrap{width:640px;margin-left:0px;}</style>', /* intended for extra styles for both visual and HTML editors buttons, needs to include the <style> tags, can use "scoped". */
								'editor_class' => '', /* add extra class(es ) to the editor textarea */
								'teeny' => true, /* output the minimal editor config used in Press This */
								'dfw' => true, /* replace the default fullscreen with DFW (supported on the front-end in WordPress 3.4) */
								'tinymce' => false, /* load TinyMCE, can be used to pass settings directly to TinyMCE using an array() */
								'quicktags' => true /* load Quicktags, can be used to pass settings directly to Quicktags using an array() */
								);
							if ( $tmpdata['admin_post_upgrade_email_content'] != "" ) {
								$content = stripslashes( $tmpdata['admin_post_upgrade_email_content'] );
							} else {
								$content = esc_html__( "<p>Howdy [#to_name#],</p><p>A new upgrade request has been submitted to your site.</p><p>Here are some details about it.</p><p>[#information_details#]</p><p>Thank You,<br/>[#site_name#]</p>", 'templatic-admin' );
							}
							wp_editor( $content, 'admin_post_upgrade_email_content', $settings );
							?>
						</td>
					</tr>
					<tr>
						<td colspan="2">
							<div class="buttons">
								<div class="inline_update">
									<a class="button-primary save alignleft quick_save" href="javascript:void( 0 );" accesskey="s"><?php echo esc_html__( "Save Changes", 'templatic-admin' ); ?></a>
									<a class="button-secondary cancel alignright" href="javascript:void( 0 );" onclick="open_quick_edit( 'edit-admin-post-upgrade', 'admin-post-upgrade' )" accesskey="c"><?php echo esc_html__( "Cancel", 'templatic-admin' ); ?></a>
									<span class="save_error" style="display:none"></span><span class="spinner"></span>
								</div>
							</div>
						</td>
					</tr>
				</table>
			</td>
		</tr>

		<tr class="client-post-upgrade alternate">
			<td><label class="form-textfield-label"><?php echo esc_html__( 'Post upgrade notification to user', 'templatic-admin' ); ?></label></td>

			<td>
				<a href="javascript:void( 0 );" onclick="open_quick_edit( 'client-post-upgrade', 'edit-client-post-upgrade' )"><?php echo esc_html__( "Quick Edit", 'templatic-admin' ); ?></a>
				|
				<a href="javascript:void( 0 );" onclick="reset_to_default( 'client_post_upgrade_email_subject', 'client_post_upgrade_email_content', 'client-post-upgrade' );"><?php echo esc_html__( "Reset", 'templatic' ); ?></a>
				<span class="spinner" style="margin:0 18px 0;"></span>
				<span class="qucik_reset"><?php echo esc_html__( "Data reset", 'templatic-admin' ); ?></span>
			</td>
		</tr>
		<tr class="edit-client-post-upgrade" style="display:none">
			<td width="100%" colspan="2">
				<h4 class="edit-sub-title">Quick Edit</h4>
				<table width="98%" align="left" class="tab-sub-table">
					<tr>
						<td style="line-height:10px">
							<label class="form-textfield-label sub-title"><?php echo esc_html__( 'Subject', 'templatic-admin' ); ?></label>
						</td>
						<td width="90%" style="line-height:10px">
							<input type="text" name="client_post_upgrade_email_subject" id="client_post_upgrade_email_subject" value="<?php
							if ( isset( $tmpdata['client_post_upgrade_email_subject'] ) ) {
								echo wp_kses_post( wp_unslash( $tmpdata['client_post_upgrade_email_subject'] ) );
							} else {
								esc_html_e( 'Payment Pending For Upgrade Request: #[#post_id#]', 'templatic' );
							}
							?>"/>
						</td>
					</tr>
					<tr>
						<td style="line-height:10px">
							<label class="form-textfield-label sub-title"><?php echo esc_html__( 'Message', 'templatic-admin' ); ?></label>
						</td>
						<td width="90%" style="line-height:10px">
							<?php
							$settings = array(
								'wpautop' => false, /* use wpautop? */
								'media_buttons' => false, /* show insert/upload button(s ) */
								'textarea_name' => 'client_post_upgrade_email_content', /* set the textarea name to something different, square brackets [] can be used here */
								'textarea_rows' => '7', /* rows="..." */
								'tabindex' => '',
								'editor_css' => '<style>.wp-editor-wrap{width:640px;margin-left:0px;}</style>', /* intended for extra styles for both visual and HTML editors buttons, needs to include the <style> tags, can use "scoped". */
								'editor_class' => '', /* add extra class(es ) to the editor textarea */
								'teeny' => true, /* output the minimal editor config used in Press This */
								'dfw' => true, /* replace the default fullscreen with DFW (supported on the front-end in WordPress 3.4) */
								'tinymce' => false, /* load TinyMCE, can be used to pass settings directly to TinyMCE using an array() */
								'quicktags' => true /* load Quicktags, can be used to pass settings directly to Quicktags using an array() */
								);
							if ( $tmpdata['client_post_upgrade_email_content'] != "" ) {
								$content = stripslashes( $tmpdata['client_post_upgrade_email_content'] );
							} else {
								$content = esc_html__( "<p>Dear [#to_name#],</p><p>Your [#post_type_name#] has been updated by you . Here is the information about the [#post_type_name#]:</p>[#information_details#]<br><p>[#site_name#]</p>", 'templatic-admin' );
							}
							wp_editor( $content, 'client_post_upgrade_email_content', $settings );
							?>
						</td>
					</tr>
					<tr>
						<td colspan="2">
							<div class="buttons">
								<div class="inline_update">
									<a class="button-primary save alignleft quick_save" href="javascript:void( 0 );" accesskey="s"><?php echo esc_html__( "Save Changes", 'templatic-admin' ); ?></a>
									<a class="button-secondary cancel alignright" href="javascript:void( 0 );" onclick="open_quick_edit( 'edit-client-post-upgrade', 'client-post-upgrade' )" accesskey="c"><?php echo esc_html__( "Cancel", 'templatic-admin' ); ?></a>
									<span class="save_error" style="display:none"></span><span class="spinner"></span>
								</div>
							</div>
						</td>
					</tr>
				</table>
			</td>
		</tr>

		<tr class="reset-password">
			<td><label class="form-textfield-label"><?php echo esc_html__( 'Password reset', 'templatic-admin' ); ?></label></td>

			<td>
				<a href="javascript:void( 0 );" onclick="open_quick_edit( 'reset-password', 'edit-reset-password' )"><?php echo esc_html__( "Quick Edit", 'templatic-admin' ); ?></a>
				|
				<a href="javascript:void( 0 );" onclick="reset_to_default( 'reset_password_subject', 'reset_password_content', 'reset-password' );"><?php echo esc_html__( "Reset", 'templatic' ); ?></a>
				<span class="spinner" style="margin:0 18px 0;"></span>
				<span class="qucik_reset"><?php echo esc_html__( "Data reset", 'templatic-admin' ); ?></span>
			</td>
		</tr>
		<tr class="edit-reset-password" style="display:none">
			<td width="100%" colspan="2">
				<h4 class="edit-sub-title">Quick Edit</h4>
				<table width="98%" align="left" class="tab-sub-table">
					<tr>
						<td style="line-height:10px">
							<label class="form-textfield-label sub-title"><?php echo esc_html__( 'Subject', 'templatic-admin' ); ?></label>
						</td>
						<td width="90%" style="line-height:10px">
							<input type="text" name="reset_password_subject" id="reset_password_subject" value="<?php
							if ( isset( $tmpdata['reset_password_subject'] ) ) {
								echo wp_kses_post( wp_unslash( $tmpdata['reset_password_subject'] ) );
							} else {
								esc_html_e( '[#site_title#] Your new password', 'templatic' );
							}
							?>"/>
						</td>
					</tr>
					<tr>
						<td style="line-height:10px">
							<label class="form-textfield-label sub-title"><?php echo esc_html__( 'Message', 'templatic-admin' ); ?></label>
						</td>
						<td width="90%" style="line-height:10px">
							<?php
							$settings = array(
								'wpautop' => false, /* use wpautop? */
								'media_buttons' => false, /* show insert/upload button(s ) */
								'textarea_name' => 'reset_password_content', /* set the textarea name to something different, square brackets [] can be used here */
								'textarea_rows' => '7', /* rows="..." */
								'tabindex' => '',
								'editor_css' => '<style>.wp-editor-wrap{width:640px;margin-left:0px;}</style>', /* intended for extra styles for both visual and HTML editors buttons, needs to include the <style> tags, can use "scoped". */
								'editor_class' => '', /* add extra class(es ) to the editor textarea */
								'teeny' => true, /* output the minimal editor config used in Press This */
								'dfw' => true, /* replace the default fullscreen with DFW (supported on the front-end in WordPress 3.4) */
								'tinymce' => false, /* load TinyMCE, can be used to pass settings directly to TinyMCE using an array() */
								'quicktags' => true /* load Quicktags, can be used to pass settings directly to Quicktags using an array() */
								);
							if ( $tmpdata['reset_password_content'] != "" ) {
								$content = stripslashes( $tmpdata['reset_password_content'] );
							} else {
								$content = esc_html__( "<p>Hi [#to_name#],</p><p>Here is the new password you have requested for your account [#user_email#].</p><p> Login URL: [#login_url#] </p><p>User name: [#user_login#]</p> <p> Password: [#user_password#]</p><p>You may change this password in your profile once you login with the new password above.</p><p>Thanks <br/> [#site_title#] </p>", 'templatic-admin' );
							}
							wp_editor( $content, 'reset_password_content', $settings );
							?>
						</td>
					</tr>
					<tr>
						<td colspan="2">
							<div class="buttons">
								<div class="inline_update">
									<a class="button-primary save alignleft quick_save" href="javascript:void( 0 );" accesskey="s"><?php echo esc_html__( "Save Changes", 'templatic-admin' ); ?></a>
									<a class="button-secondary cancel alignright" href="javascript:void( 0 );" onclick="open_quick_edit( 'edit-reset-password', 'reset-password' )" accesskey="c"><?php echo esc_html__( "Cancel", 'templatic-admin' ); ?></a>
									<span class="save_error" style="display:none"></span><span class="spinner"></span>
								</div>
							</div>
						</td>
					</tr>
				</table>
			</td>
		</tr>



		<tr class="claim-ownership alternate">
			<td><label class="form-textfield-label"><?php echo esc_html__( 'Claim Ownership', 'templatic-admin' ); ?></label></td>

			<td>
				<a href="javascript:void( 0 );" onclick="open_quick_edit( 'claim-ownership', 'edit-claim-ownership' )"><?php echo esc_html__( "Quick Edit", 'templatic-admin' ); ?></a>
				|
				<a href="javascript:void( 0 );" onclick="reset_to_default( 'claim_ownership_subject', 'claim_ownership_content', 'claim-ownership' );"><?php echo esc_html__( "Reset", 'templatic' ); ?></a>
				<span class="spinner" style="margin:0 18px 0;"></span>
				<span class="qucik_reset"><?php echo esc_html__( "Data reset", 'templatic-admin' ); ?></span>
			</td>
		</tr>
		<tr class="edit-claim-ownership" style="display:none">
			<td width="100%" colspan="2">
				<h4 class="edit-sub-title">Quick Edit</h4>
				<table width="98%" align="left" class="tab-sub-table">
					<tr>
						<td style="line-height:10px">
							<label class="form-textfield-label sub-title"><?php echo esc_html__( 'Subject', 'templatic-admin' ); ?></label>
						</td>
						<td width="90%" style="line-height:10px">
							<input type="text" name="claim_ownership_subject" id="claim_ownership_subject" value="<?php
							if ( isset( $tmpdata['claim_ownership_subject'] ) ) {
								echo wp_kses_post( wp_unslash( $tmpdata['claim_ownership_subject'] ) );
							} else {
								esc_html_e( 'New Claim Submitted', 'templatic' );
							}
							?>"/>
						</td>
					</tr>
					<tr>
						<td style="line-height:10px">
							<label class="form-textfield-label sub-title"><?php echo esc_html__( 'Message', 'templatic-admin' ); ?></label>
						</td>
						<td width="90%" style="line-height:10px">
							<?php
							$settings = array(
								'wpautop' => false, /* use wpautop? */
								'media_buttons' => false, /* show insert/upload button(s ) */
								'textarea_name' => 'claim_ownership_content', /* set the textarea name to something different, square brackets [] can be used here */
								'textarea_rows' => '7', /* rows="..." */
								'tabindex' => '',
								'editor_css' => '<style>.wp-editor-wrap{width:640px;margin-left:0px;}</style>', /* intended for extra styles for both visual and HTML editors buttons, needs to include the <style> tags, can use "scoped". */
								'editor_class' => '', /* add extra class(es ) to the editor textarea */
								'teeny' => true, /* output the minimal editor config used in Press This */
								'dfw' => true, /* replace the default fullscreen with DFW (supported on the front-end in WordPress 3.4) */
								'tinymce' => false, /* load TinyMCE, can be used to pass settings directly to TinyMCE using an array() */
								'quicktags' => true /* load Quicktags, can be used to pass settings directly to Quicktags using an array() */
								);
							if ( $tmpdata['claim_ownership_content'] != "" ) {
								$content = stripslashes( $tmpdata['claim_ownership_content'] );
							} else {
								$content = esc_html__( "<p>Dear admin,</p><p>[#claim_name#] has submitted a claim for the post below.</p><p>[#message#]</p><p>Link: [#post_title#]</p><p>From: [#your_name#]</p><p>Email: [#claim_email#]<p>Phone Number: [#your_number#]</p>", 'templatic-admin' );
							}
							wp_editor( $content, 'claim_ownership_content', $settings );
							?>
						</td>
					</tr>
					<tr>
						<td colspan="2">
							<div class="buttons">
								<div class="inline_update">
									<a class="button-primary save alignleft quick_save" href="javascript:void( 0 );" accesskey="s"><?php echo esc_html__( "Save Changes", 'templatic-admin' ); ?></a>
									<a class="button-secondary cancel alignright" href="javascript:void( 0 );" onclick="open_quick_edit( 'edit-claim-ownership', 'claim-ownership' )" accesskey="c"><?php echo esc_html__( "Cancel", 'templatic-admin' ); ?></a>
									<span class="save_error" style="display:none"></span><span class="spinner"></span>
								</div>
							</div>
						</td>
					</tr>
				</table>
			</td>
		</tr>

		<tr class="listing-expiration">
			<td><label class="form-textfield-label"><?php echo esc_html__( 'Listing expiration notification to user', 'templatic-admin' ); ?></label></td>

			<td>
				<a href="javascript:void( 0 );" onclick="open_quick_edit( 'listing-expiration', 'edit-listing-expiration' )"><?php echo esc_html__( "Quick Edit", 'templatic-admin' ); ?></a>
				|
				<a href="javascript:void( 0 );" onclick="reset_to_default( 'listing_expiration_subject', 'listing_expiration_content', 'listing-expiration' );"><?php echo esc_html__( "Reset", 'templatic' ); ?></a>
				<span class="spinner" style="margin:0 18px 0;"></span>
				<span class="qucik_reset"><?php echo esc_html__( "Data reset", 'templatic-admin' ); ?></span>
			</td>
		</tr>
		<tr class="edit-listing-expiration" style="display:none">
			<td width="100%" colspan="2">
				<h4 class="edit-sub-title">Quick Edit</h4>
				<table width="98%" align="left" class="tab-sub-table">
					<tr>
						<td style="line-height:10px">
							<label class="form-textfield-label sub-title"><?php echo esc_html__( 'Subject', 'templatic-admin' ); ?></label>
						</td>
						<td width="90%" style="line-height:10px">
							<input type="text" name="listing_expiration_subject" id="listing_expiration_subject" value="<?php
							if ( isset( $tmpdata['listing_expiration_subject'] ) ) {
								echo wp_kses_post( wp_unslash( $tmpdata['listing_expiration_subject'] ) );
							} else {
								esc_html_e( 'Listing expiration Notification', 'templatic' );
							}
							?>"/>
						</td>
					</tr>
					<tr>
						<td style="line-height:10px">
							<label class="form-textfield-label sub-title"><?php echo esc_html__( 'Message', 'templatic-admin' ); ?></label>
						</td>
						<td width="90%" style="line-height:10px">
							<?php
							$settings = array(
								'wpautop' => false, /* use wpautop? */
								'media_buttons' => false, /* show insert/upload button(s ) */
								'textarea_name' => 'listing_expiration_content', /* set the textarea name to something different, square brackets [] can be used here */
								'textarea_rows' => '7', /* rows="..." */
								'tabindex' => '',
								'editor_css' => '<style>.wp-editor-wrap{width:640px;margin-left:0px;}</style>', /* intended for extra styles for both visual and HTML editors buttons, needs to include the <style> tags, can use "scoped". */
								'editor_class' => '', /* add extra class(es ) to the editor textarea */
								'teeny' => true, /* output the minimal editor config used in Press This */
								'dfw' => true, /* replace the default fullscreen with DFW (supported on the front-end in WordPress 3.4) */
								'tinymce' => false, /* load TinyMCE, can be used to pass settings directly to TinyMCE using an array() */
								'quicktags' => true /* load Quicktags, can be used to pass settings directly to Quicktags using an array() */
								);
							if ( $tmpdata['listing_expiration_content'] != "" ) {
								$content = stripslashes( $tmpdata['listing_expiration_content'] );
							} else {

								$content = esc_html__( "<p>Dear [#user_login#],<p><p>Your listing -<b>[#post_title#]</b> posted on [#post_date#] and paid on [#transection_date#] for [#alivedays#] days.</p><p>Is going to expire in [#days_left#] day(s ). Once the listing expires, it will no longer appear on the site.</p><p> In case you wish to renew this listing, please login to your member area on our site and renew it as soon as it expires. You can login on the following link [#site_login_url_link#].</p><p>Your login ID is <b>[#user_login#]</b> and Email ID is <b>[#user_email#]</b>.</p><p>Thank you,<br />[#site_name#].</p>", 'templatic-admin' );
							}

							wp_editor( $content, 'listing_expiration_content', $settings );
							?>
						</td>
					</tr>
					<tr>
						<td colspan="2">
							<div class="buttons">
								<div class="inline_update">
									<a class="button-primary save alignleft quick_save" href="javascript:void( 0 );" accesskey="s"><?php echo esc_html__( "Save Changes", 'templatic-admin' ); ?></a>
									<a class="button-secondary cancel alignright" href="javascript:void( 0 );" onclick="open_quick_edit( 'edit-listing-expiration', 'listing-expiration' )" accesskey="c"><?php echo esc_html__( "Cancel", 'templatic-admin' ); ?></a>
									<span class="save_error" style="display:none"></span><span class="spinner"></span>
								</div>
							</div>
						</td>
					</tr>
				</table>
			</td>
		</tr>

		<tr class="payment-cancelled alternate">
			<td><label class="form-textfield-label"><?php echo esc_html__( 'Cancelled payment notification to user ', 'templatic-admin' ); ?></label></td>

			<td>
				<a href="javascript:void( 0 );" onclick="open_quick_edit( 'payment-cancelled', 'edit-payment-cancelled' )"><?php echo esc_html__( "Quick Edit", 'templatic-admin' ); ?></a>
				|
				<a href="javascript:void( 0 );" onclick="reset_to_default( 'payment_cancelled_subject', 'payment_cancelled_content', 'payment-cancelled' );"><?php echo esc_html__( "Reset", 'templatic' ); ?></a>
				<span class="spinner" style="margin:0 18px 0;"></span>
				<span class="qucik_reset"><?php echo esc_html__( "Data reset", 'templatic-admin' ); ?></span>
			</td>
		</tr>
		<tr class="edit-payment-cancelled " style="display:none">
			<td width="100%" colspan="2">
				<h4 class="edit-sub-title">Quick Edit</h4>
				<table width="98%" align="left" class="tab-sub-table">
					<tr>
						<td style="line-height:10px">
							<label class="form-textfield-label sub-title"><?php echo esc_html__( 'Subject', 'templatic-admin' ); ?></label>
						</td>
						<td width="90%" style="line-height:10px">
							<input type="text" name="payment_cancelled_subject" id="payment_cancelled_subject" value="<?php
							if ( isset( $tmpdata['payment_cancelled_subject'] ) ) {
								echo wp_kses_post( wp_unslash( $tmpdata['payment_cancelled_subject'] ) );
							} else {
								esc_html_e( 'Payment Cancelled', 'templatic' );
							}
							?>"/>
						</td>
					</tr>
					<tr>
						<td style="line-height:10px">
							<label class="form-textfield-label sub-title"><?php echo esc_html__( 'Message', 'templatic-admin' ); ?></label>
						</td>
						<td width="90%" style="line-height:10px">
							<?php
							$settings = array(
								'wpautop' => false, /* use wpautop? */
								'media_buttons' => false, /* show insert/upload button(s ) */
								'textarea_name' => 'payment_cancelled_content', /* set the textarea name to something different, square brackets [] can be used here */
								'textarea_rows' => '7', /* rows="..." */
								'tabindex' => '',
								'editor_css' => '<style>.wp-editor-wrap{width:640px;margin-left:0px;}</style>', /* intended for extra styles for both visual and HTML editors buttons, needs to include the <style> tags, can use "scoped". */
								'editor_class' => '', /* add extra class(es ) to the editor textarea */
								'teeny' => true, /* output the minimal editor config used in Press This */
								'dfw' => true, /* replace the default fullscreen with DFW (supported on the front-end in WordPress 3.4) */
								'tinymce' => false, /* load TinyMCE, can be used to pass settings directly to TinyMCE using an array() */
								'quicktags' => true /* load Quicktags, can be used to pass settings directly to Quicktags using an array() */
								);
							if ( $tmpdata['payment_cancelled_content'] != "" ) {
								$content = stripslashes( $tmpdata['payment_cancelled_content'] );
							} else {
								$content = esc_html__( "[#post_type#] has been cancelled with transaction id [#transection_id#]", 'templatic-admin' );
							}
							wp_editor( $content, 'payment_cancelled_content', $settings );
							?>
						</td>
					</tr>
					<tr>
						<td colspan="2">
							<div class="buttons">
								<div class="inline_update">
									<a class="button-primary save alignleft quick_save" href="javascript:void( 0 );" accesskey="s"><?php echo esc_html__( "Save Changes", 'templatic-admin' ); ?></a>
									<a class="button-secondary cancel alignright" href="javascript:void( 0 );" onclick="open_quick_edit( 'edit-payment-cancelled', 'payment-cancelled' )" accesskey="c"><?php echo esc_html__( "Cancel", 'templatic-admin' ); ?></a>
									<span class="save_error" style="display:none"></span><span class="spinner"></span>
								</div>
							</div>
						</td>
					</tr>
				</table>
			</td>
		</tr>

		<tr class="update-listing-notification">
			<td><label class="form-textfield-label"><?php echo esc_html__( 'Listing updated notification to user', 'templatic-admin' ); ?></label></td>

			<td>
				<a href="javascript:void( 0 );" onclick="open_quick_edit( 'update-listing-notification', 'edit-update-listing-notification' )"><?php echo esc_html__( "Quick Edit", 'templatic-admin' ); ?></a>
				|
				<a href="javascript:void( 0 );" onclick="reset_to_default( 'update_listing_notification_subject', 'update_listing_notification_content', 'update-listing-notification' );"><?php echo esc_html__( "Reset", 'templatic' ); ?></a>
				<span class="spinner" style="margin:0 18px 0;"></span>
				<span class="qucik_reset"><?php echo esc_html__( "Data reset", 'templatic-admin' ); ?></span>
			</td>
		</tr>
		<tr class="edit-update-listing-notification" style="display:none">
			<td width="100%" colspan="2">
				<h4 class="edit-sub-title">Quick Edit</h4>
				<table width="98%" align="left" class="tab-sub-table">
					<tr>
						<td style="line-height:10px">
							<label class="form-textfield-label sub-title"><?php echo esc_html__( 'Subject', 'templatic-admin' ); ?></label>
						</td>
						<td width="90%" style="line-height:10px">
							<input type="text" name="update_listing_notification_subject" id="update_listing_notification_subject" value="<?php
							if ( isset( $tmpdata['update_listing_notification_subject'] ) ) {
								echo wp_kses_post( wp_unslash( $tmpdata['update_listing_notification_subject'] ) );
							} else {
								esc_html_e( '[#post_type#] ID #[#submition_Id#] has been updated', 'templatic' );
							}
							?>"/>
						</td>
					</tr>
					<tr>
						<td style="line-height:10px">
							<label class="form-textfield-label sub-title"><?php echo esc_html__( 'Message', 'templatic-admin' ); ?></label>
						</td>
						<td width="90%" style="line-height:10px">
							<?php
							$settings = array(
								'wpautop' => false, /* use wpautop? */
								'media_buttons' => false, /* show insert/upload button(s ) */
								'textarea_name' => 'update_listing_notification_content', /* set the textarea name to something different, square brackets [] can be used here */
								'textarea_rows' => '7', /* rows="..." */
								'tabindex' => '',
								'editor_css' => '<style>.wp-editor-wrap{width:640px;margin-left:0px;}</style>', /* intended for extra styles for both visual and HTML editors buttons, needs to include the <style> tags, can use "scoped". */
								'editor_class' => '', /* add extra class(es ) to the editor textarea */
								'teeny' => true, /* output the minimal editor config used in Press This */
								'dfw' => true, /* replace the default fullscreen with DFW (supported on the front-end in WordPress 3.4) */
								'tinymce' => false, /* load TinyMCE, can be used to pass settings directly to TinyMCE using an array() */
								'quicktags' => true /* load Quicktags, can be used to pass settings directly to Quicktags using an array() */
								);
							if ( $tmpdata['update_listing_notification_content'] != "" ) {
								$content = stripslashes( $tmpdata['update_listing_notification_content'] );
							} else {
								$content = esc_html__( "<p>Dear [#to_name#],</p><p>[#post_type#] ID #[#submition_Id#] has been updated on your site.</p><p>You can review it again by clicking on its title in this email or through your admin dashboard.</p>[#information_details#]<br><p>[#site_name#]</p>", 'templatic-admin' );
							}
							wp_editor( $content, 'update_listing_notification_content', $settings );
							?>
						</td>
					</tr>
					<tr>
						<td colspan="2">
							<div class="buttons">
								<div class="inline_update">
									<a class="button-primary save alignleft quick_save" href="javascript:void( 0 );" accesskey="s"><?php echo esc_html__( "Save Changes", 'templatic-admin' ); ?></a>
									<a class="button-secondary cancel alignright" href="javascript:void( 0 );" onclick="open_quick_edit( 'edit-update-listing-notification', 'update-listing-notification' )" accesskey="c"><?php echo esc_html__( "Cancel", 'templatic-admin' ); ?></a>
									<span class="save_error" style="display:none"></span><span class="spinner"></span>
								</div>
							</div>
						</td>
					</tr>
				</table>
			</td>
		</tr>


		<tr class="update-listing-notification-admin">
			<td><label class="form-textfield-label"><?php echo esc_html__( 'Listing updated notification to admin', 'templatic-admin' ); ?></label></td>

			<td>
				<a href="javascript:void( 0 );" onclick="open_quick_edit( 'update-listing-notification-admin', 'edit-update-listing-notification-admin' )"><?php echo esc_html__( "Quick Edit", 'templatic-admin' ); ?></a>
				|
				<a href="javascript:void( 0 );" onclick="reset_to_default( 'update_listing_notification_admin_subject', 'update_listing_notification_admin_content', 'update-listing-notification-admin' );"><?php echo esc_html__( "Reset", 'templatic' ); ?></a>
				<span class="spinner" style="margin:0 18px 0;"></span>
				<span class="qucik_reset"><?php echo esc_html__( "Data reset", 'templatic-admin' ); ?></span>
			</td>
		</tr>
		<tr class="edit-update-listing-notification-admin" style="display:none">
			<td width="100%" colspan="2">
				<h4 class="edit-sub-title">Quick Edit</h4>
				<table width="98%" align="left" class="tab-sub-table">
					<tr>
						<td style="line-height:10px">
							<label class="form-textfield-label sub-title"><?php echo esc_html__( 'Subject', 'templatic-admin' ); ?></label>
						</td>
						<td width="90%" style="line-height:10px">
							<input type="text" name="update_listing_notification_admin_subject" id="update_listing_notification_admin_subject" value="<?php
							if ( isset( $tmpdata['update_listing_notification_admin_subject'] ) ) {
								echo wp_kses_post( wp_unslash( $tmpdata['update_listing_notification_admin_subject'] ) );
							} else {
								esc_html_e( '[#post_type#] ID #[#submition_Id#] has been updated', 'templatic' );
							}
							?>"/>
						</td>
					</tr>
					<tr>
						<td style="line-height:10px">
							<label class="form-textfield-label sub-title"><?php echo esc_html__( 'Message', 'templatic-admin' ); ?></label>
						</td>
						<td width="90%" style="line-height:10px">
							<?php
							$settings = array(
								'wpautop' => false, /* use wpautop? */
								'media_buttons' => false, /* show insert/upload button(s ) */
								'textarea_name' => 'update_listing_notification_admin_content', /* set the textarea name to something different, square brackets [] can be used here */
								'textarea_rows' => '7', /* rows="..." */
								'tabindex' => '',
								'editor_css' => '<style>.wp-editor-wrap{width:640px;margin-left:0px;}</style>', /* intended for extra styles for both visual and HTML editors buttons, needs to include the <style> tags, can use "scoped". */
								'editor_class' => '', /* add extra class(es ) to the editor textarea */
								'teeny' => true, /* output the minimal editor config used in Press This */
								'dfw' => true, /* replace the default fullscreen with DFW (supported on the front-end in WordPress 3.4) */
								'tinymce' => false, /* load TinyMCE, can be used to pass settings directly to TinyMCE using an array() */
								'quicktags' => true /* load Quicktags, can be used to pass settings directly to Quicktags using an array() */
								);
							if ( $tmpdata['update_listing_notification_admin_content'] != "" ) {
								$content = stripslashes( $tmpdata['update_listing_notification_admin_content'] );
							} else {
								$content = esc_html__( "<p>Dear [#to_name#],</p><p>[#post_type#] ID #[#submition_Id#] has been updated on your site.</p><p>You can review it again by clicking on its title in this email or through your admin dashboard.</p>[#information_details#]<br><p>[#site_name#]</p>", 'templatic-admin' );
							}
							wp_editor( $content, 'update_listing_notification_admin_content', $settings );
							?>
						</td>
					</tr>
					<tr>
						<td colspan="2">
							<div class="buttons">
								<div class="inline_update">
									<a class="button-primary save alignleft quick_save" href="javascript:void( 0 );" accesskey="s"><?php echo esc_html__( "Save Changes", 'templatic-admin' ); ?></a>
									<a class="button-secondary cancel alignright" href="javascript:void( 0 );" onclick="open_quick_edit( 'edit-update-listing-notification-admin', 'update-listing-notification-admin' )" accesskey="c"><?php echo esc_html__( "Cancel", 'templatic-admin' ); ?></a>
									<span class="save_error" style="display:none"></span><span class="spinner"></span>
								</div>
							</div>
						</td>
					</tr>
				</table>
			</td>
		</tr>



		<tr class="renew-listing-notification alternate">
			<td><label class="form-textfield-label"><?php echo esc_html__( 'Listing renewal notification to user', 'templatic-admin' ); ?></label></td>

			<td>
				<a href="javascript:void( 0 );" onclick="open_quick_edit( 'renew-listing-notification', 'edit-renew-listing-notification' )"><?php echo esc_html__( "Quick Edit", 'templatic-admin' ); ?></a>
				|
				<a href="javascript:void( 0 );" onclick="reset_to_default( 'renew_listing_notification_subject', 'renew_listing_notification_content', 'renew-listing-notification' );"><?php echo esc_html__( "Reset", 'templatic' ); ?></a>
				<span class="spinner" style="margin:0 18px 0;"></span>
				<span class="qucik_reset"><?php echo esc_html__( "Data reset", 'templatic-admin' ); ?></span>
			</td>
		</tr>
		<tr class="edit-renew-listing-notification" style="display:none">
			<td width="100%" colspan="2">
				<h4 class="edit-sub-title">Quick Edit</h4>
				<table width="98%" align="left" class="tab-sub-table">
					<tr>
						<td style="line-height:10px">
							<label class="form-textfield-label sub-title"><?php echo esc_html__( 'Subject', 'templatic-admin' ); ?></label>
						</td>
						<td width="90%" style="line-height:10px">
							<input type="text" name="renew_listing_notification_subject" id="renew_listing_notification_subject" value="<?php
							if ( isset( $tmpdata['renew_listing_notification_subject'] ) ) {
								echo wp_kses_post( wp_unslash( $tmpdata['renew_listing_notification_subject'] ) );
							} else {
								esc_html_e( '[#post_type#] renew of ID:#[#submition_Id#]', 'templatic' );
							}
							?>"/>
						</td>
					</tr>
					<tr>
						<td style="line-height:10px">
							<label class="form-textfield-label sub-title"><?php echo esc_html__( 'Message', 'templatic-admin' ); ?></label>
						</td>
						<td width="90%" style="line-height:10px">
							<?php
							$settings = array(
								'wpautop' => false, /* use wpautop? */
								'media_buttons' => false, /* show insert/upload button(s ) */
								'textarea_name' => 'renew_listing_notification_content', /* set the textarea name to something different, square brackets [] can be used here */
								'textarea_rows' => '7', /* rows="..." */
								'tabindex' => '',
								'editor_css' => '<style>.wp-editor-wrap{width:640px;margin-left:0px;}</style>', /* intended for extra styles for both visual and HTML editors buttons, needs to include the <style> tags, can use "scoped". */
								'editor_class' => '', /* add extra class(es ) to the editor textarea */
								'teeny' => true, /* output the minimal editor config used in Press This */
								'dfw' => true, /* replace the default fullscreen with DFW (supported on the front-end in WordPress 3.4) */
								'tinymce' => false, /* load TinyMCE, can be used to pass settings directly to TinyMCE using an array() */
								'quicktags' => true /* load Quicktags, can be used to pass settings directly to Quicktags using an array() */
								);
							if ( $tmpdata['renew_listing_notification_content'] != "" ) {
								$content = stripslashes( $tmpdata['renew_listing_notification_content'] );
							} else {
								$content = esc_html__( "<p>Dear [#to_name#],</p><p>Your [#post_type#] has been renewed by you . Here is the information about the [#post_type#]:</p><p>[#information_details#]</p><p>[#site_name#]</p>", 'templatic-admin' );
							}
							wp_editor( $content, 'renew_listing_notification_content', $settings );
							?>
						</td>
					</tr>
					<tr>
						<td colspan="2">
							<div class="buttons">
								<div class="inline_update">
									<a class="button-primary save alignleft quick_save" href="javascript:void( 0 );" accesskey="s"><?php echo esc_html__( "Save Changes", 'templatic-admin' ); ?></a>
									<a class="button-secondary cancel alignright" href="javascript:void( 0 );" onclick="open_quick_edit( 'edit-renew-listing-notification', 'renew-listing-notification' )" accesskey="c"><?php echo esc_html__( "Cancel", 'templatic-admin' ); ?></a>
									<span class="save_error" style="display:none"></span><span class="spinner"></span>
								</div>
							</div>
						</td>
					</tr>
				</table>
			</td>
		</tr>

		<tr class="pending-listing-notification">
			<td><label class="form-textfield-label"><?php echo esc_html__( 'Pending listing notification to admin', 'templatic-admin' ); ?></label></td>

			<td>
				<a href="javascript:void( 0 );" onclick="open_quick_edit( 'pending-listing-notification', 'edit-pending-listing-notification' )"><?php echo esc_html__( "Quick Edit", 'templatic-admin' ); ?></a>
				|
				<a href="javascript:void( 0 );" onclick="reset_to_default( 'pending_listing_notification_subject', 'pending_listing_notification_content', 'pending-listing-notification' );"><?php echo esc_html__( "Reset", 'templatic' ); ?></a>
				<span class="spinner" style="margin:0 18px 0;"></span>
				<span class="qucik_reset"><?php echo esc_html__( "Data reset", 'templatic-admin' ); ?></span>
			</td>
		</tr>
		<tr class="edit-pending-listing-notification" style="display:none">
			<td width="100%" colspan="2">
				<h4 class="edit-sub-title"><?php echo esc_html__( "Quick Edit", 'templatic-admin' ); ?></h4>
				<table width="98%" align="left" class="tab-sub-table">
					<tr>
						<td style="line-height:10px">
							<label class="form-textfield-label sub-title"><?php echo esc_html__( 'Subject', 'templatic-admin' ); ?></label>
						</td>
						<td width="90%" style="line-height:10px">
							<input type="text" name="pending_listing_notification_subject" id="pending_listing_notification_subject" value="<?php
							if ( isset( $tmpdata['pending_listing_notification_subject'] ) ) {
								echo wp_kses_post( wp_unslash( $tmpdata['pending_listing_notification_subject'] ) );
							} else {
								esc_html_e( 'Listing payment not confirmed', 'templatic' );
							}
							?>"/>
						</td>
					</tr>
					<tr>
						<td style="line-height:10px">
							<label class="form-textfield-label sub-title"><?php echo esc_html__( 'Message', 'templatic-admin' ); ?></label>
						</td>
						<td width="90%" style="line-height:10px">
							<?php
							$settings = array(
								'wpautop' => false, /* use wpautop? */
								'media_buttons' => false, /* show insert/upload button(s ) */
								'textarea_name' => 'pending_listing_notification_content', /* set the textarea name to something different, square brackets [] can be used here */
								'textarea_rows' => '7', /* rows="..." */
								'tabindex' => '',
								'editor_css' => '<style>.wp-editor-wrap{width:640px;margin-left:0px;}</style>', /* intended for extra styles for both visual and HTML editors buttons, needs to include the <style> tags, can use "scoped". */
								'editor_class' => '', /* add extra class(es ) to the editor textarea */
								'teeny' => true, /* output the minimal editor config used in Press This */
								'dfw' => true, /* replace the default fullscreen with DFW (supported on the front-end in WordPress 3.4) */
								'tinymce' => false, /* load TinyMCE, can be used to pass settings directly to TinyMCE using an array() */
								'quicktags' => true /* load Quicktags, can be used to pass settings directly to Quicktags using an array() */
								);
							if ( $tmpdata['pending_listing_notification_content'] != "" ) {
								$content = stripslashes( $tmpdata['pending_listing_notification_content'] );
							} else {
								$content = esc_html__( "<p>Hi [#to_name#],<br />A listing request on the below details has been rejected.<p>[#transaction_details#]</p>Please try again later.<br />Thanks you.<br />[#site_name#]</p>", 'templatic-admin' );
							}
							wp_editor( $content, 'pending_listing_notification_content', $settings );
							?>
						</td>
					</tr>
					<tr>
						<td colspan="2">
							<div class="buttons">
								<div class="inline_update">
									<a class="button-primary save alignleft quick_save" href="javascript:void( 0 );" accesskey="s"><?php echo esc_html__( "Save Changes", 'templatic-admin' ); ?></a>
									<a class="button-secondary cancel alignright" href="javascript:void( 0 );" onclick="open_quick_edit( 'edit-pending-listing-notification', 'pending-listing-notification' )" accesskey="c"><?php echo esc_html__( "Cancel", 'templatic-admin' ); ?></a>
									<span class="save_error" style="display:none"></span><span class="spinner"></span>
								</div>
							</div>
						</td>
					</tr>
				</table>
			</td>
		</tr>

		<?php do_action( 'tevolution_after_email_type_setting' ); ?>

	</tbody>
</table>
</div>
<!-- End the div of email settings Which is start from line no. 349 <div id='email_settings'> -->
</td>
</tr>
<!-- Notifications settings start -->

<div id="notifications_settings" class="tmpl-email-settings">

	<div class="tevo_sub_title" style="padding-top: 10px;"><?php echo esc_html__( 'Notification Content Settings', 'templatic-admin' ); ?></div>
	<p class="tevolution_desc"><?php echo esc_html__( 'These are the messages that appear on your site after certain actions (like content submissions ). ', 'templatic-admin' ) ?></p>

	<table class="widefat post email-wide-table email-settings">
		<thead>
			<tr>
				<th class="first-th">
					<label for="notification_title" class="form-textfield-label"><?php echo esc_html__( 'Notification Title', 'templatic-admin' ); ?></label>
				</th>

				<th class="last-th">
					<label for="msg_desc" class="form-textfield-label"><?php echo esc_html__( 'Actions', 'templatic-admin' ); ?></label>
				</th>
			</tr>
		</thead>
		<tbody>
			<tr class="post-submission-not alternate">
				<td><label class="form-textfield-label"><?php echo esc_html__( 'Successful post submission message', 'templatic-admin' ); ?></label></td>

				<td><a href="javascript:void( 0 );" onclick="open_quick_edit( 'post-submission-not', 'edit-post-submission-not' )"><?php echo esc_html__( "Quick Edit", 'templatic-admin' ); ?></a>
					|
					<a href="javascript:void( 0 );" onclick="reset_to_default( '', 'post_added_success_msg_content', 'post-submission-not' );"><?php echo esc_html__( "Reset", 'templatic-admin' ); ?></a>
					<span class="spinner" style="margin:0 18px 0;"></span>
					<span class="qucik_reset"><?php echo esc_html__( "Data reset", 'templatic-admin' ); ?></span>
				</td>
			</tr>
			<tr class="edit-post-submission-not" style="display:none">
				<td width="100%" colspan="2">
					<h4 class="edit-sub-title"><?php echo esc_html__( "Quick Edit", 'templatic-admin' ); ?></h4>
					<table width="98%" align="left" class="tab-sub-table">
						<tr>
							<td style="line-height:10px">
								<label class="form-textfield-label sub-title"><?php echo esc_html__( 'Message', 'templatic-admin' ); ?></label>
							</td>
							<td width="90%" style="line-height:10px">
								<?php
								$settings = array(
									'wpautop' => false, /* use wpautop? */
									'media_buttons' => false, /* show insert/upload button(s ) */
									'textarea_name' => 'post_added_success_msg_content', /* set the textarea name to something different, square brackets [] can be used here */
									'textarea_rows' => '7', /* rows="..." */
									'tabindex' => '',
									'editor_css' => '<style>.wp-editor-wrap{width:640px;margin-left:0px;}</style>', /* intended for extra styles for both visual and HTML editors buttons, needs to include the <style> tags, can use "scoped". */
									'editor_class' => '', /* add extra class(es ) to the editor textarea */
									'teeny' => true, /* output the minimal editor config used in Press This */
									'dfw' => true, /* replace the default fullscreen with DFW (supported on the front-end in WordPress 3.4) */
									'tinymce' => false, /* load TinyMCE, can be used to pass settings directly to TinyMCE using an array() */
									'quicktags' => true /* load Quicktags, can be used to pass settings directly to Quicktags using an array() */
									);
								if ( $tmpdata['post_added_success_msg_content'] != "" ) {
									$content = stripslashes( $tmpdata['post_added_success_msg_content'] );
								} else {
									$content = '<p>' . esc_html__( "Thank you! We have successfully received the submitted information.", 'templatic-admin' ) . '</p><p>[#submited_information_link#]</p><p>' . esc_html__( "Thanks!", 'templatic-admin' ) . '<br/> [#site_name#].</p>';
								}
								wp_editor( $content, 'post_added_success_msg_content', $settings );
								?>
							</td>
						</tr>
						<tr>
							<td colspan="2">
								<div class="buttons">
									<div class="inline_update">
										<a class="button-primary save alignleft quick_save" href="javascript:void( 0 );" accesskey="s"><?php echo esc_html__( "Save Changes", 'templatic-admin' ); ?></a>
										<a class="button-secondary alignright cancel " href="javascript:void( 0 );" onclick="open_quick_edit( 'edit-post-submission-not', 'post-submission-not' )" accesskey="c"><?php echo esc_html__( 'Cancel', 'templatic-admin' ); ?></a>
										<span class="save_error" style="display:none"></span><span class="spinner"></span>
									</div>
								</div>
							</td>
						</tr>
					</table>
				</td>
			</tr>
			<tr class="payment-successful">
				<td><label class="form-textfield-label"><?php echo esc_html__( 'Payment successfully received message', 'templatic-admin' ); ?></label></td>

				<td><a href="javascript:void( 0 );" onclick="open_quick_edit( 'payment-successful', 'edit-payment-successful' )"><?php echo esc_html__( "Quick Edit", 'templatic-admin' ); ?></a>
					|
					<a href="javascript:void( 0 );" onclick="reset_to_default( '', 'post_payment_success_msg_content', 'payment-successful' );"><?php echo esc_html__( "Reset", 'templatic-admin' ); ?></a>
					<span class="spinner" style="margin:0 18px 0;"></span>
					<span class="qucik_reset"><?php echo esc_html__( "Data reset", 'templatic-admin' ); ?></span>
				</td>
			</tr>
			<tr class="edit-payment-successful" style="display:none">
				<td width="100%" colspan="2">
					<h4 class="edit-sub-title"><?php echo esc_html__( "Quick Edit", 'templatic-admin' ); ?></h4>
					<table width="98%" align="left" class="tab-sub-table">
						<tr>
							<td style="line-height:10px">
								<label class="form-textfield-label sub-title"><?php echo esc_html__( "Message", 'templatic-admin' ); ?></label>
							</td>
							<td width="90%" style="line-height:10px">
								<?php
								$settings = array(
									'wpautop' => false, /* use wpautop? */
									'media_buttons' => false, /* show insert/upload button(s ) */
									'textarea_name' => 'post_payment_success_msg_content', /* set the textarea name to something different, square brackets [] can be used here */
									'textarea_rows' => '7', /* rows="..." */
									'tabindex' => '',
									'editor_css' => '<style>.wp-editor-wrap{width:640px;margin-left:0px;}</style>', /* intended for extra styles for both visual and HTML editors buttons, needs to include the <style> tags, can use "scoped". */
									'editor_class' => '', /* add extra class(es ) to the editor textarea */
									'teeny' => true, /* output the minimal editor config used in Press This */
									'dfw' => true, /* replace the default fullscreen with DFW (supported on the front-end in WordPress 3.4) */
									'tinymce' => false, /* load TinyMCE, can be used to pass settings directly to TinyMCE using an array() */
									'quicktags' => true /* load Quicktags, can be used to pass settings directly to Quicktags using an array() */
									);
								if ( $tmpdata['post_payment_success_msg_content'] != "" ) {
									$content = stripslashes( $tmpdata['post_payment_success_msg_content'] );
								} else {
									$content = '<h4>' . esc_html__( "Your payment has been successfully received. The submitted content is now published.", 'templatic-admin' ) . '</h4><p><a href="[#submited_information_link#]" >' . esc_html__( "View your submitted information", 'templatic-admin' ) . '</a></p><h5>' . esc_html__( "Thank you for participating at", 'templatic-admin' ) . ' [#site_name#].</h5>';
								}
								wp_editor( $content, 'post_payment_success_msg_content', $settings );
								?>
							</td>
						</tr>
						<tr>
							<td colspan="2">
								<div class="buttons">
									<div class="inline_update">
										<a class="button-primary save quick_save" href="javascript:void( 0 );" accesskey="s"><?php echo esc_html__( "Save Changes", 'templatic-admin' ); ?></a>
										<a class="button-secondary cancel " href="javascript:void( 0 );" onclick="open_quick_edit( 'edit-payment-successful', 'payment-successful' )" accesskey="c"><?php echo esc_html__( "Cancel", 'templatic-admin' ); ?></a>
										<span class="save_error" style="display:none"></span><span class="spinner"></span>
									</div>
								</div>
							</td>
						</tr>
					</table>
				</td>
			</tr>
			<tr class="payment-cancel alternate">
				<td><label class="form-textfield-label"><?php echo esc_html__( 'Payment cancelled message', 'templatic-admin' ); ?></label></td>

				<td><a href="javascript:void( 0 );" onclick="open_quick_edit( 'payment-cancel', 'edit-payment-cancel' )"><?php echo esc_html__( "Quick Edit", 'templatic-admin' ); ?></a>
					|
					<a href="javascript:void( 0 );" onclick="reset_to_default( '', 'post_payment_cancel_msg_content', 'payment-cancel' );"><?php echo esc_html__( "Reset", 'templatic-admin' ); ?></a>
					<span class="spinner" style="margin:0 18px 0;"></span>
					<span class="qucik_reset"><?php echo esc_html__( "Data reset", 'templatic-admin' ); ?></span>
				</td>
			</tr>
			<tr class="edit-payment-cancel alternate" style="display:none">
				<td width="100%" colspan="2">
					<h4 class="edit-sub-title"><?php echo esc_html__( "Quick Edit", 'templatic-admin' ); ?></h4>
					<table width="98%" align="left" class="tab-sub-table">
						<tr>
							<td style="line-height:10px">
								<label class="form-textfield-label sub-title"><?php echo esc_html__( 'Message', 'templatic-admin' ); ?></label>
							</td>
							<td width="90%" style="line-height:10px">
								<?php
								$settings = array(
									'wpautop' => false, /* use wpautop? */
									'media_buttons' => false, /* show insert/upload button(s ) */
									'textarea_name' => 'post_payment_cancel_msg_content', /* set the textarea name to something different, square brackets [] can be used here */
									'textarea_rows' => '7', /* rows="..." */
									'tabindex' => '',
									'editor_css' => '<style>.wp-editor-wrap{width:640px;margin-left:0px;}</style>', /* intended for extra styles for both visual and HTML editors buttons, needs to include the <style> tags, can use "scoped". */
									'editor_class' => '', /* add extra class(es ) to the editor textarea */
									'teeny' => true, /* output the minimal editor config used in Press This */
									'dfw' => true, /* replace the default fullscreen with DFW (supported on the front-end in WordPress 3.4) */
									'tinymce' => false, /* load TinyMCE, can be used to pass settings directly to TinyMCE using an array() */
									'quicktags' => true /* load Quicktags, can be used to pass settings directly to Quicktags using an array() */
									);
								if ( $tmpdata['post_payment_cancel_msg_content'] != "" ) {
									$content = stripslashes( $tmpdata['post_payment_cancel_msg_content'] );
								} else {
									$content = '<h3>Sorry! Your listing has been canceled due to some reason. To get the details on it, contact us at [#admin_email#].</h3><h5>Thank you for your kind co-operation with [#site_name#]</h5>';
								}
								wp_editor( $content, 'post_payment_cancel_msg_content', $settings );
								?>
							</td>
						</tr>
						<tr>
							<td colspan="2">
								<div class="buttons">
									<div class="inline_update">
										<a class="button-primary save quick_save" href="javascript:void( 0 );" accesskey="s"><?php echo esc_html__( "Save Changes", 'templatic-admin' ); ?></a>
										<a class="button-secondary cancel" href="javascript:void( 0 );" onclick="open_quick_edit( 'edit-payment-cancel', 'payment-cancel' )" accesskey="c"><?php echo esc_html__( "Cancel", 'templatic-admin' ); ?></a>
										<span class="save_error" style="display:none"></span><span class="spinner"></span>
									</div>
								</div>
							</td>
						</tr>
					</table>
				</td>
			</tr>
			<tr class="prebank-transfer">
				<td><label class="form-textfield-label"><?php echo esc_html__( 'PreBank transfer success message', 'templatic-admin' ); ?></label></td>

				<td><a href="javascript:void( 0 );" onclick="open_quick_edit( 'prebank-transfer', 'edit-prebank-transfer' )"><?php echo esc_html__( "Quick Edit", 'templatic-admin' ); ?></a>
					|
					<a href="javascript:void( 0 );" onclick="reset_to_default( '', 'post_pre_bank_trasfer_msg_content', 'prebank-transfer' );"><?php echo esc_html__( "Reset", 'templatic-admin' ); ?></a>
					<span class="spinner" style="margin:0 18px 0;"></span>
					<span class="qucik_reset"><?php echo esc_html__( "Data reset", 'templatic-admin' ); ?></span>
				</td>
			</tr>
			<tr class="edit-prebank-transfer" style="display:none">
				<td width="100%" colspan="2">
					<h4 class="edit-sub-title"><?php echo esc_html__( "Quick Edit", 'templatic-admin' ); ?></h4>
					<table width="98%" align="left" class="tab-sub-table">
						<tr>
							<td style="line-height:10px">
								<label class="form-textfield-label sub-title"><?php echo esc_html__( "Message", 'templatic-admin' ); ?></label>
							</td>
							<td width="90%" style="line-height:10px">
								<?php
								$settings = array(
									'wpautop' => false, /* use wpautop? */
									'media_buttons' => false, /* show insert/upload button(s ) */
									'textarea_name' => 'post_pre_bank_trasfer_msg_content', /* set the textarea name to something different, square brackets [] can be used here */
									'textarea_rows' => '7', /* rows="..." */
									'tabindex' => '',
									'editor_css' => '<style>.wp-editor-wrap{width:640px;margin-left:0px;}</style>', /* intended for extra styles for both visual and HTML editors buttons, needs to include the <style> tags, can use "scoped". */
									'editor_class' => '', /* add extra class(es ) to the editor textarea */
									'teeny' => true, /* output the minimal editor config used in Press This */
									'dfw' => true, /* replace the default fullscreen with DFW (supported on the front-end in WordPress 3.4) */
									'tinymce' => false, /* load TinyMCE, can be used to pass settings directly to TinyMCE using an array() */
									'quicktags' => true /* load Quicktags, can be used to pass settings directly to Quicktags using an array() */
									);
								if ( $tmpdata['post_pre_bank_trasfer_msg_content'] != "" ) {
									$content = stripslashes( $tmpdata['post_pre_bank_trasfer_msg_content'] );
								} else {
									$content = '<p>' . esc_html__( "To complete the transaction please transfer ", 'templatic-admin' ) . ' <b>[#payable_amt#] </b> ' . esc_html__( "to our bank account on the details below.", 'templatic-admin' ) . '</p><p>' . esc_html__( "Bank Name:", 'templatic-admin' ) . ' <b>[#bank_name#]</b></p><p>' . esc_html__( "Account Number:", 'templatic-admin' ) . ' <b>[#account_number#]</b></p><p>' . esc_html__( "Please include the following number as the reference", 'templatic-admin' ) . '[#submition_Id#]</p><p>[#submited_information_link#] </p><p>' . esc_html__( "Thank you!", 'templatic-admin' ) . '<br/>[#site_name#]</p>';
								}
								wp_editor( $content, 'post_pre_bank_trasfer_msg_content', $settings );
								?>
							</td>
						</tr>
						<tr>
							<td colspan="2">
								<div class="buttons">
									<div class="inline_update">
										<a class="button-primary save quick_save" href="javascript:void( 0 );" accesskey="s"><?php echo esc_html__( "Save Changes", 'templatic-admin' ); ?></a>
										<a class="button-secondary cancel " href="javascript:void( 0 );" onclick="open_quick_edit( 'edit-prebank-transfer', 'prebank-transfer' )" accesskey="c"><?php echo esc_html__( 'Cancel', 'templatic-admin' ); ?></a>
										<span class="save_error" style="display:none"></span>
										<span class="spinner"></span>
									</div>
								</div>
							</td>
						</tr>
					</table>
				</td>
			</tr>
			<?php do_action( 'tevolution_after_email_notification_setting' ); ?>
		</tbody>
	</table>
</div>
<?php
break;
} // End switch().
}
