<?php
/**
 * Add/edit user custom field.
 *
 * @package Wordpress
 * @subpackage Tevolution
 */

global $wpdb, $current_user;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
if ( isset( $_REQUEST['cf'] ) ) {
	$post_id = intval( $_REQUEST['cf'] );
}
$post_val = get_post( $post_id );
if ( isset( $_POST['save_user'] ) && '' != $_POST['save_user'] ) {
	$my_post = array();
	if ( isset( $_REQUEST['site_title'] ) ) {
		$my_post['post_title'] = sanitize_text_field( $_POST['site_title'] );
	}
	if ( isset( $_REQUEST['htmlvar_name'] ) ) {
		$my_post['post_name'] = wp_kses_post( wp_unslash( $_POST['htmlvar_name'] ) );
	}
	if ( isset( $_REQUEST['admin_desc'] ) ) {
		$my_post['post_content'] = wp_kses_post( wp_unslash( $_POST['admin_desc'] ) );
	}
	$my_post['post_status'] = ( isset( $_POST['is_active'] ) ) ? wp_kses_post( wp_unslash( $_POST['is_active'] ) ): 'draft';
	$my_post['post_type'] = 'custom_user_field';
	$custom = array(
		'ctype' => ( isset( $_POST['ctype'] ) ) ? wp_kses_post( wp_unslash( $_POST['ctype'] ) ): '',
		'sort_order' => ( isset( $_POST['sort_order'] ) ) ? wp_kses_post( wp_unslash( $_POST['sort_order'] ) ) : '',
		'option_values'	=> ( isset( $_POST['option_values'] ) ) ? wp_kses_post( wp_unslash( $_POST['option_values'] ) ) :'',
		'option_titles' => ( isset( $_POST['option_titles'] ) ) ? wp_kses_post( wp_unslash( $_POST['option_titles'] ) ) :'',
		'is_require' => ( isset( $_POST['is_require'] ) ) ? wp_kses_post( wp_unslash( $_POST['is_require'] ) ) :0,
		'on_registration' => ( isset( $_POST['on_registration'] ) ) ? wp_kses_post( wp_unslash( $_POST['on_registration'] ) ) :0,
		'on_profile' => ( isset( $_POST['on_profile'] ) ) ? wp_kses_post( wp_unslash( $_POST['on_profile'] ) ) :0,
		'on_author_page' => ( isset( $_REQUEST['on_author_page'] ) ) ? wp_kses_post( wp_unslash( $_REQUEST['on_author_page'] ) ) :0,
		);
	if ( isset( $_REQUEST['cf'] ) ) {
		$cf = intval( $_REQUEST['cf'] );
		$my_post['ID'] = intval( $_REQUEST['cf'] );
		$last_postid = wp_insert_post( $my_post );
		$msgtype = 'edit-suc';
	} else {
		$last_postid = wp_insert_post( $my_post );
		$msgtype = 'add-suc';
	}
	/* Finish the place geo_latitude and geo_longitude in postcodes table*/
	if ( is_plugin_active( 'sitepress-multilingual-cms/sitepress.php' ) ) {
		if ( function_exists( 'wpml_insert_templ_post' ) ) {
			wpml_insert_templ_post( $last_postid, 'custom_user_field' ); /* insert post in language */
		}
	}
	foreach ( $custom as $key => $val ) {
		update_post_meta( $last_postid, $key, $val );
	}

	$url = site_url() . '/wp-admin/admin.php';
	echo '<form action="' . esc_url( $url ) . '#option_display_custom_usermeta" method="get" id="frm_edit_customuser_fields" name="frm_edit_customuser_fields">
	<input type="hidden" value="custom_setup" name="page"><input type="hidden" value="user_custom_fields" name="ctab"><input type="hidden" value="' . wp_kses_post( wp_unslash( $msgtype ) ) . '" name="msgtype">
</form>
<script>document.frm_edit_customuser_fields.submit();</script>';
	exit;
} // End if().
?>
<script type="text/javascript" src="<?php echo esc_url( TEMPL_PLUGIN_URL ) . 'tmplconnector/monetize/templatic-registration/add_user_custom_fields_validations.js';?>"></script>
<div class="wrap">
	<div class="icon32 icon32-posts-post" id="icon-edit"><br></div>
	<h2>
		<?php if ( isset( $_REQUEST['cf'] ) ) {
			echo esc_html__( 'Edit Custom User Meta', 'templatic-admin' );
} else {
			echo esc_html__( 'Add a field for users&rsquo; profile', 'templatic-admin' );
}?>
		<a href="<?php echo esc_url( site_url() );?>/wp-admin/admin.php?page=custom_setup&ctab=user_custom_fields" name="btnviewlisting" id="edit_custom_user_custom_field" class="add-new-h2" title="<?php echo esc_html__( 'Back to Manage fields list', 'templatic-admin' );?>">
			<?php echo esc_html__( 'Back to Manage fields list', 'templatic-admin' ); ?>
		</a>
	</h2>
	<form class="form_style" action="<?php echo esc_url( site_url() );?>/wp-admin/admin.php?page=custom_setup&ctab=user_custom_fields&action=addnew" method="post" name="custom_fields_frm" onsubmit="return chk_userfield_form();">

		<input type="hidden" name="save" value="1" />
		<?php if ( isset( $_REQUEST['cf'] ) ) {?>
		<input type="hidden" name="cf" value="<?php echo intval( $_REQUEST['cf'] );?>" />
		<?php }?>
		<input type="hidden" name="post_type" id="post_type" value="registration" />
		<input type="hidden" name="clabels" id="clabels" value="<?php if ( isset( $post_val->clabels ) ) { echo wp_kses_post( wp_unslash( $post_val->clabels ) ); } ?>" />
		<input type="hidden" name="default_value" id="default_value" value="<?php if ( isset( $post_val->default_value ) ) { echo wp_kses_post( wp_unslash( $post_val->default_value ) ); } ?>" />
		<input type="hidden" name="admin_title" id="admin_title" value="<?php if ( isset( $post_val->admin_title ) ) { echo wp_kses_post( wp_unslash( $post_val->admin_title ) ); } ?>" />

		<table class="form-table" style="width:50%;" id="form_table_user_custom_field">
			<tbody>
				<!-- field type start -->
				<tr style="display:block;" >
					<th>
						<label for="field_type" class="form-textfield-label"><?php echo esc_html__( 'Field type', 'templatic-admin' );?></label>
					</th>
					<td>
						<select name='ctype' id='ctype' onchange="usershow_option_add(this.value)" >
							<option value="date" <?php if ( get_post_meta( $post_id,'ctype',true ) == 'date' ) { echo 'selected="selected"';}?>><?php echo esc_html__( 'Date Picker', 'templatic-admin' );?></option>
							<option value="multicheckbox" <?php if ( get_post_meta( $post_id,'ctype',true ) == 'multicheckbox' ) { echo 'selected="selected"';}?>><?php echo esc_html__( 'Multi Checkbox', 'templatic-admin' );?></option>
							<option value="radio" <?php if ( get_post_meta( $post_id,'ctype',true ) == 'radio' ) { echo 'selected="selected"';}?>><?php echo esc_html__( 'Radio', 'templatic-admin' );?></option>
							<option value="select" <?php if ( get_post_meta( $post_id,'ctype',true ) == 'select' ) { echo 'selected="selected"';}?>><?php echo esc_html__( 'Select', 'templatic-admin' );?></option>
							<option value="text" <?php if ( get_post_meta( $post_id,'ctype',true ) == 'text' ) { echo 'selected="selected"';}?>><?php echo esc_html__( 'Text', 'templatic-admin' );?></option>
							<option value="textarea" <?php if ( get_post_meta( $post_id,'ctype',true ) == 'textarea' ) { echo 'selected="selected"';}?>><?php echo esc_html__( 'Textarea', 'templatic-admin' );?></option>
							<option value="texteditor" <?php if ( get_post_meta( $post_id,'ctype',true ) == 'texteditor' ) { echo 'selected="selected"';}?>><?php echo esc_html__( 'Text Editor', 'templatic-admin' );?></option>
							<option value="head" <?php if ( get_post_meta( $post_id,'ctype',true ) == 'head' ) { echo 'selected="selected"';}?>><?php echo esc_html__( 'Text Heading', 'templatic-admin' );?></option>
							<option value="upload" <?php if ( get_post_meta( $post_id,'ctype',true ) == 'upload' ) { echo 'selected="selected"';}?>><?php echo esc_html__( 'Upload', 'templatic-admin' );?></option>
						</select>
					</td>
				</tr>
				<!-- field type end -->

				<!-- option value start -->
				<tr id="ctype_option_tr_id" <?php if ( get_post_meta( $post_id,'ctype',true ) == 'select' ) {
					?> style="display:block;" <?php
} else {
						?> style="display:none;" <?php
}?> >
					<th><?php echo esc_html__( 'Option values', 'templatic-admin' );?></th>
					<td>
						<input type="text" class="regular-text" name='option_values' id='option_values' value="<?php echo wp_kses_post( wp_unslash( get_post_meta( $post_id,'option_values',true ) ) );?>" size="50" />
						<p class="description"><?php echo esc_html__( 'Separate multiple option values with a comma. eg. Yes, No(Do not add space after comma)', 'templatic-admin' );?></p>
					</td>
				</tr>
				<tr id="ctype_titles_tr_id" <?php if ( get_post_meta( $post_id,'ctype',true ) == 'select' ) {
					?> style="display:block;" <?php
} else {
						?> style="display:none;" <?php
}?> >
					<th><?php echo esc_html__( 'Option titles', 'templatic-admin' );?></th>
					<td>
						<input type="text" class="regular-text" name='option_titles' id='option_titles' value="<?php echo wp_kses_post( wp_unslash( get_post_meta( $post_id,'option_titles',true ) ) );?>" size="50" />
						<p class="description"><?php echo esc_html__( 'Separate multiple option titles with a comma. eg. Yes, No', 'templatic-admin' );?></p>
					</td>
				</tr>
				<!-- option value end -->

				<!-- fieldname start -->
				<tr id="ctype_option_tr_id" <?php if ( get_post_meta( $post_id,'ctype',true ) == 'select' ) {
					?> style="display:block;" <?php
} else {
						?> style="display:block;" <?php
}?> >
					<th><?php echo esc_html__( 'Field name', 'templatic-admin' );?></th>
					<td>
						<input type="text" class="regular-text" name="site_title" id="site_title" value="<?php if ( isset( $post_val->post_title ) ) { echo wp_kses_post( wp_unslash( $post_val->post_title ) ); } ?>" />
						<p class="description"><?php echo esc_html__( 'The name you enter here will be used in both the registration form and in the user dashboard. ', 'templatic-admin' );?></p>
					</td>
				</tr>
				<!-- field name end -->

				<!-- field description start -->
				<tr id="ctype_option_tr_id" <?php if ( get_post_meta( $post_id,'ctype',true ) == 'select' ) {
					?> style="display:block;" <?php
} else {
						?> style="display:none;" <?php
}?> >
					<th><?php echo esc_html__( 'Field description', 'templatic-admin' );?></th>
					<td>
						<input type="text" class="regular-text" name="admin_desc" id="admin_desc" value="<?php if ( isset( $post_val->post_content ) ) { echo wp_kses_post( wp_unslash( $post_val->post_content ) ); } ?>" />
						<p class="description"><?php echo esc_html__( 'Custom field description which will appear in the front-end as well as the backend. ', 'templatic-admin' );?></p>
					</td>
				</tr>
				<!-- field description end -->

				<!-- htmlvar_name1 name start-->
				<tr id="htmlvar_name1" style="display:block;" >
					<th><?php echo esc_html__( 'HTML variable name', 'templatic-admin' );?></th>
					<td>
						<input type="text" class="regular-text" name="htmlvar_name" id="htmlvar_name" value="<?php if ( isset( $post_val->post_name ) ) { echo wp_kses_post( wp_unslash( $post_val->post_name ) ); } ?>"<?php if ( isset( $_REQUEST['cf'] ) ) { ?>readonly="readonly"<?php } ?> />
						<p class="description"><?php echo esc_html__( 'Enter a unique name for the field. Use only lowercase letters and numbers, no space allowed. ', 'templatic-admin' );?></p>
					</td>
				</tr>
				<!-- htmlvar_name1 name end-->

				<!-- start order1 start-->
				<tr id="sort_order1" style="display:block;" >
					<th><?php echo esc_html__( 'Position ( Display order )', 'templatic-admin' );?></th>
					<td>
						<input type="text" class="regular-text" name='sort_order' id='sort_order' value="<?php echo wp_kses_post( wp_unslash( get_post_meta( $post_id,'sort_order',true ) ) );?>" />
						<p class="description"><?php echo esc_html__( 'Enter a number that will determine the position of the field inside the registration form, e.g., 5. ', 'templatic-admin' );?></p>
					</td>
				</tr>
				<!-- start order1 end-->

				<!-- status start-->
				<tr id="sort_order1" style="display:block;" >
					<th><?php echo esc_html__( 'Active', 'templatic-admin' );?></th>
					<td>
						<input type="checkbox" name="is_active" id="is_active" value="publish" <?php if ( isset( $post_val->post_status ) && $post_val->post_status == 'publish' ) { echo 'checked="checked"'; }?> />&nbsp;<label for="is_active"><?php echo esc_html__( 'Yes', 'templatic-admin' );?></label>
						<p class="description"><?php echo esc_html__( 'Uncheck this box only if you want to create the field but not use it right away. ', 'templatic-admin' );?></p></td>
					</tr>
					<!-- status end-->

					<!-- Compulsory start -->
					<tr id="is_require_id" <?php if ( get_post_meta( $post_id,'ctype',true ) == 'head' ) {?> style="display:none;" <?php } else { ?>style="display:block;"<?php }?>>
						<th><?php echo esc_html__( 'Compulsory', 'templatic-admin' );?></th>
						<td>
							<input type="checkbox" name='is_require' id='is_require' value="1" <?php if ( get_post_meta( $post_id,'is_require',true ) == '1' ) { echo 'checked="checked"';}?>/>&nbsp;<label for='is_require'><?php echo esc_html__( 'Yes', 'templatic-admin' );?></label>
							<p class="description"><?php echo esc_html__( 'Check this option if this should be a required field.', 'templatic-admin' );?></p>
						</td>
					</tr>
					<!-- Compulsory end-->

					<!-- on Registration page start -->
					<tr style="display:block;">
						<th><?php echo esc_html__( 'Show the field on', 'templatic-admin' );?></th>
						<td>

							<p id="for_profile"><input type="checkbox" name='on_profile' id='on_profile' value="1" <?php if ( get_post_meta( $post_id,'on_profile',true ) == '1' ) { echo 'checked="checked"';}?>/>&nbsp;<label for='on_profile'><?php echo esc_html__( 'Edit profile page', 'templatic-admin' );?></label></p>
							<p id="for_registration"><input type="checkbox" name='on_registration' id='on_registration' value="1" <?php if ( get_post_meta( $post_id,'on_registration',true ) == '1' ) { echo 'checked="checked"';}?>/>&nbsp;<label for='on_registration'><?php echo esc_html__( 'Registration page', 'templatic-admin' );?></label>
								<p class="description"><?php echo esc_html__( 'Only username and email field will be shown in pop up register form. ', 'templatic-admin' ); ?></p></p>
								<p id="for_author"><input type="checkbox" name='on_author_page' id='on_author_page' value="1" <?php if ( get_post_meta( $post_id,'on_author_page',true ) == '1' ) { echo 'checked="checked"';}?>/>&nbsp;<label for='on_author_page'><?php echo esc_html__( 'User dashboard page', 'templatic-admin' );?></label></p>

						</td>
					</tr>
					<!--in authot box page end-->

					<tr style="display:block">
						<td class="save" colspan="2">
							<?php
							if ( isset( $_REQUEST['cf'] ) && '' != $_REQUEST['cf'] ) {
								$val = __( 'Update Changes', 'templatic-admin' );
							} else {
								$val = __( 'Save all changes', 'templatic-admin' );
							}
							?>
							<input type="submit" class="button button-primary button-hero" name="save_user" id="save" value="<?php echo wp_kses_post( wp_unslash( $val ) ); ?>" />
						</td>
					</tr>
			</tbody>
		</table>
	</form>
</div>
<script type="text/javascript">
	function usershow_option_add(htmltype)
	{
		if ( htmltype== 'select' || htmltype== 'multiselect' || htmltype== 'radio' || htmltype== 'multicheckbox' )
		{
			document.getElementById( 'ctype_option_tr_id' ) .style.display='block';
			 document.getElementById( 'ctype_titles_tr_id' ).style.display='block';
		}else
		{
			document.getElementById( 'ctype_option_tr_id' ) .style.display='none';
			 document.getElementById( 'ctype_titles_tr_id' ).style.display='none';
		}

		if ( htmltype== 'head' )
		{
			 document.getElementById( 'is_require_id' ).style.display='none';
		}
		else
		{
			 document.getElementById( 'is_require_id' ).style.display='block';
		}
	}
	 if ( document.getElementById( 'ctype' ).value)
	{
		usershow_option_add(document.getElementById( 'ctype' ).value)	;
	}
</script>
