<?php

function bravepop_dynamic_woo_mostSold(){
   $mostSoldQuery =  array(
      'limit'     => 5,
      'meta_key' => 'total_sales', 
      'orderby'  => array( 'meta_value_num' => 'DESC', 'title' => 'ASC' ),
   );
   $query    = new WC_Product_Query( $mostSoldQuery );
   $most_soldIDItems = $query->get_products();

   return bravepop_dynamic_woo_loop( $most_soldIDItems );
}

function bravepop_dynamic_woo_upsell(){
   $product = wc_get_product();
   if(!$product){ return array();}
   $upsell_ids = $product->get_upsell_ids();
   if(is_array($upsell_ids) && count($upsell_ids) === 0){
      $upsell_ids = wc_get_related_products( $product->get_id(), 1);
   }
   if($upsell_ids && is_array($upsell_ids) && count($upsell_ids) > 0){
      $upsellProductQuery =  array( 'limit'=> 5, 'include' => $upsell_ids );
      $query    = new WC_Product_Query( $upsellProductQuery );
      $upsellItems = $query->get_products();
      return bravepop_dynamic_woo_loop( $upsellItems );
   }

}

function bravepop_dynamic_woo_crossell(){
   $product = wc_get_product();
   if(!$product){ return array();}
   $crossell_ids = $product->get_cross_sell_ids();

   if(is_array($crossell_ids) && count($crossell_ids) === 0){
      $crossell_ids = wc_get_related_products( $product->get_id(), 1);
   }

   if($crossell_ids && is_array($crossell_ids) && count($crossell_ids) > 0){
      $crossell_idsProductQuery =  array( 'limit'=> 5, 'include' => $crossell_ids );
      $query    = new WC_Product_Query( $crossell_idsProductQuery );
      $crossell_Items = $query->get_products();
      return bravepop_dynamic_woo_loop( $crossell_Items );
   }
}

function bravepop_related_products($count=3, $type='related'){
   $product = wc_get_product();
   if(!$product){ return wc_get_products( array( 'limit' => $count ) ); }
   
   if($type === 'upsell'){
      $product_ids = $product->get_upsell_ids();
   }else if($type === 'cross_sell'){
      $product_ids = $product->get_cross_sell_ids();
   }else{
      $product_ids = wc_get_related_products( $product->get_id(), $count);
   }
   
   if(($type === 'upsell' || $type === 'cross_sell') && is_array($product_ids) && count($product_ids) < $count){
      $relatedCount = $count - count($product_ids);
      $relatedProducts = wc_get_related_products( $product->get_id(), $relatedCount, $product_ids);
      if($relatedProducts && count($relatedProducts) > 0){
         $product_ids = array_merge($product_ids, $relatedProducts);
      }
   }

   $finalProductQuery =  array( 'limit'=> $count, 'include' => $product_ids );
   $query    = new WC_Product_Query( $finalProductQuery );
   return $query->get_products();
}


function bravepop_posts_element_query($postType, $filterType, $postCount, $orderby, $customIds, $categories, $tags){
   if(!$postType){ return; }
   if($customIds && $filterType === 'custom'){
      $the_query = new WP_Query( array( 'post_type' => 'post' ,'orderby' => $orderby, 'posts_per_page' => $postCount, 'post__in' => $customIds ) );
   }elseif($categories && $filterType === 'categories'){
      $the_query = new WP_Query( array( 'post_type' => 'post' ,'orderby' => $orderby, 'posts_per_page' => $postCount, 'ignore_sticky_posts' => 1, 'cat' => $categories ? implode(",",$categories) : '' ) );
   }elseif($tags && $filterType === 'tags'){
      $the_query = new WP_Query( array( 'post_type' => 'post' ,'orderby' => $orderby, 'posts_per_page' => $postCount, 'ignore_sticky_posts' => 1, 'tag__in' => $tags ) );
   }else{
      $the_query = new WP_Query( array( 'post_type' => 'post' ,'orderby' => $orderby, 'posts_per_page' => $postCount, 'ignore_sticky_posts' => 1) );
   }

   if($postType === 'popular'){
      $the_query = new WP_Query( array( 'post_type' => 'post' , 'posts_per_page' => $postCount, 'ignore_sticky_posts' => 1, 'orderby' => ($orderby === 'rand' ? 'comment_count rand' : 'comment_count') ) );
   }

   if($postType === 'related'){
      global $post;
      $args = array( 'post_type' => 'post', 'orderby' => $orderby , 'posts_per_page' => $postCount, 'ignore_sticky_posts' => 1, 'post__not_in' => array($post->ID));
      
      if($filterType === 'categories'){
         $postCategories = wp_get_post_categories( $post->ID, array( 'fields' => 'ids' ) );
         $args['category__in'] = $postCategories;
      }
      if($filterType === 'tags'){
         $postTags = wp_get_post_tags( $post->ID, array( 'fields' => 'ids' ) );
         $args['tag__in'] = $postTags;
      }

      $the_query = new WP_Query( $args );

      //If there are no related posts, display the latest posts
      if($the_query->found_posts === 0){
         $the_query = new WP_Query( array( 'post_type' => 'post', 'orderby' => $orderby , 'posts_per_page' => $postCount, 'ignore_sticky_posts' => 1, 'post__not_in' => array($post->ID)));
      }
      //If Related Posts do not have all the posts in the slots, fill the empty slots with latest posts
      if($the_query->found_posts > 0 && $the_query->found_posts < $postCount ){
         $missingCount = $postCount - $the_query->found_posts;
         $excluded = array();
         if(isset($the_query->posts) && is_array($the_query->posts) && count($the_query->posts)){
            foreach ($the_query->posts as $key => $post) {
               if($post->ID){   $excluded[] = $post->ID;   }
            }
         }
         if($missingCount  > 0){
            $fill_query = new WP_Query( array( 'post_type' => 'post', 'orderby' => $orderby , 'posts_per_page' => $missingCount, 'ignore_sticky_posts' => 1, 'post__not_in' => $excluded));
            if(isset($the_query->posts) && is_array($the_query->posts) && count($the_query->posts)){
               foreach ($fill_query->posts as $key => $fost) {
                  if($fost->ID){   $the_query->posts[] = $fost;   }
               }
            }
            $the_query->post_count = count($the_query->posts);
         }
      }
   }

   return $the_query;

}

function bravepop_prepare_text_content($content){
   $finalCotnent = $content;
   global $bravepop_global;
   if(strpos($content, "{{visitor_country}}") !== false && !empty($bravepop_global['user_country'])){ 
      $finalCotnent = str_replace('{{visitor_country}}', $bravepop_global['user_country'], $finalCotnent);
   }

   if(strpos($content, "{{loggedin_user_email}}") !== false || strpos($content, "{{loggedin_user_name}}") !== false || strpos($content, "{{loggedin_user_firstname}}") !== false ){ 
      $currentUser = bravepop_getCurrentUser();
      if(strpos($content, "{{loggedin_user_email}}") !== false && !empty($currentUser['email'])){
         $finalCotnent = str_replace('{{loggedin_user_email}}', $currentUser['email'], $finalCotnent);
      }
      if(strpos($content, "{{loggedin_user_name}}") !== false && !empty($currentUser['name'])){
         $finalCotnent = str_replace('{{loggedin_user_name}}', $currentUser['name'], $finalCotnent);
      }
      if(strpos($content, "{{loggedin_user_firstname}}") !== false && !empty($currentUser['firstname'])){
         $finalCotnent = str_replace('{{loggedin_user_firstname}}', $currentUser['firstname'], $finalCotnent);
      }
   }

   //if(isset($field->defaultType) && $field->defaultType === 'utm' && !empty($field->defaultValue) && isset($_GET[$field->defaultValue]) ){ $defaultValue = 'value="'.$_GET[$field->defaultValue].'"';  }

   if(strpos($content, "{{utm-") !== false){
      $utms = preg_match_all('/({{utm-)+(.*?)}}/i', $finalCotnent, $utmArray);
      if(isset($utmArray[0]) && isset($utmArray[2]) && is_array($utmArray[0]) && is_array($utmArray[2])){
         foreach ($utmArray[2] as $idx => $utmKey) {
            $utmFullKey = isset($utmArray[0][$idx]) ? $utmArray[0][$idx] : '';
            if($utmFullKey){
               $utmVal = isset($_GET[$utmKey]) && !empty($_GET[$utmKey]) ? $_GET[$utmKey] : '';
               $finalCotnent = str_replace($utmFullKey, $utmVal, $finalCotnent);
            }
         }
      }
   }

   if(strpos($content, "{{current_year}}") !== false  || strpos($content, "{{current_month}}") !== false || strpos($content, "{{current_date}}") !== false ){
      if(strpos($content, "{{current_year}}") !== false){
         $finalCotnent = str_replace('{{current_year}}', date_i18n('Y'), $finalCotnent);
      }
      if(strpos($content, "{{current_month}}") !== false){
         $finalCotnent = str_replace('{{current_month}}', date_i18n('F'), $finalCotnent);
      }
      if(strpos($content, "{{current_date}}") !== false){
         $finalCotnent = str_replace('{{current_date}}', date_i18n('D'), $finalCotnent);
      }
   }

   return $finalCotnent;
}