<?php
if ( ! class_exists( 'BravePop_Sender_Advanced' ) ) {
   
   class BravePop_Sender_Advanced {

      protected $api_key;

      function __construct() {
         $braveSettings = get_option('_bravepopup_settings');
         $integrations = $braveSettings && isset($braveSettings['integrations']) ? $braveSettings['integrations'] : array() ;
         $this->api_key = isset($integrations['sender']->api)  ? $integrations['sender']->api  : '';
      }
      
      public function get_fields($apiKey=''){
         $apiKey  = $apiKey ? $apiKey : $this->api_key;
         if(!$apiKey){ return error_log('API KEY MISSING!!!!!');}

         $args = array(
            'headers' => array(
               'Authorization' => 'Bearer ' .$apiKey
            )
         );

         $theData = array('fields'=>array(), 'tags' => array());

         //Fields Request
         $fieldsResponse = wp_remote_get( 'https://api.sender.net/v2/fields', $args );
         if( !is_wp_error( $fieldsResponse ) ) {
            $fieldsBody = wp_remote_retrieve_body( $fieldsResponse );
            $fieldsData = json_decode( $fieldsBody );

            if($fieldsData && isset($fieldsData->data) && is_array($fieldsData->data)){
               $fields = $fieldsData->data;
               $finalFields = array();
               foreach ($fields as $key => $field) {
                  $fieldItem = new stdClass();
                  $fieldItem->id = isset($field->name) ? $field->name : '';
                  $fieldItem->name = isset($field->title) ? $field->title : '';
                  $fieldItem->type = isset($field->type) ? $field->type : 'text';
                  $finalFields[] = $fieldItem;

               }

               $theData['fields'] = $finalFields;
            }

         }

         return wp_json_encode($theData);
      }


   }

}
?>