<?php
/**
 * The Header for our theme.
 *
 * The header template is generally used on every page of your site. Nearly all other templates call it
 * somewhere near the top of the file. It is used mostly as an opening wrapper, which is closed with the
 * footer.php file. It also executes key functions needed by the theme, child themes, and plugins.
 * @package WordPress
 * @subpackage Supreme
 * @since Supreme 1.1
 */
?>
<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
<meta http-equiv="Content-Type" content="<?php bloginfo( 'html_type' ); ?>; charset=<?php bloginfo( 'charset' ); ?>" />
<meta name="viewport" content="width=device-width, initial-scale=1.0"/>
<meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
<title>
	<?php wp_title();?>
</title>

<?php
if ( function_exists( 'supreme_get_favicon' ) ) {
	if ( supreme_get_favicon() ) { ?>
			<link rel="shortcut icon" href="<?php  echo supreme_get_favicon(); ?>" /><?php 	}
}
wp_head(); // wp_head
do_action( 'supreme_enqueue_script' );
?>
<link rel="stylesheet" href="<?php echo get_stylesheet_uri(); ?>" type="text/css" media="all" />
<link rel="stylesheet" href="<?php echo get_template_directory_uri() . '/css/admin_style.css'; ?>" type="text/css" media="all" />


<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">



<link rel="profile" href="https://gmpg.org/xfn/11" />
<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>" />
<?php
if ( function_exists( 'supreme_prefix' ) ) {
  $supreme2_theme_settings = get_option( supreme_prefix() . '_theme_settings' );
if ( file_exists( get_template_directory() . '/custom.css' ) && file_get_contents( get_template_directory() . '/custom.css' ) != '' ) { ?>
	<link href="<?php echo get_template_directory_uri(); ?>/custom.css" rel="stylesheet" type="text/css" />
<?php }
if ( isset( $supreme2_theme_settings['enable_sticky_header_menu'] ) && $supreme2_theme_settings['enable_sticky_header_menu'] == 1 ) {
	 wp_enqueue_script( 'header-sticky-menu',get_template_directory_uri() . '/js/sticky_menu.js',array( 'jquery' ) );
}
}
if ( (isset( $_REQUEST['page'] ) && ($_REQUEST['page'] == 'preview' || $_REQUEST['page'] == 'success')) && is_plugin_active( 'sitepress-multilingual-cms/sitepress.php' ) ) {
	icl_lang_sel_nav_css( $show = true );
}
?>
<!--[if lt IE 9]>
<script src="//html5shim.googlecode.com/svn/trunk/html5.js"></script>
<![endif]-->   
<!--[if IE]>
<style>
	body{word-wrap:inherit!important;}
</style>
<![endif]-->
<script type="text/javascript">
  jQuery( document ).ready(function() {
	jQuery('strong.prev.page-numbers').html( "<i class='fas fa-angle-left'></i>" );
	jQuery('strong.next.page-numbers').html( "<i class='fas fa-angle-right'></i>" );
	jQuery('.woocommerce-pagination li a.prev.page-numbers').html( "<i class='fas fa-angle-left'></i>" );
	jQuery('.woocommerce-pagination li a.next.page-numbers').html( "<i class='fas fa-angle-right'></i>" );
  });
  
</script>

<?php
/*if(get_theme_mod('fontawesome_link_txt')!='')
{
	?>
	<script src="<?php echo get_theme_mod('fontawesome_link_txt');?>"></script>
<?php
}*/
?>
</head>

<body class="<?php if ( function_exists( 'supreme_body_class' ) ) {supreme_body_class();} ?>">
	<?php do_action( 'after_body' );?>
	<div class="supreme_wrapper">
	<?php do_action( 'open_body' ); // supreme_open_body
	//if(wpmd_is_phone()){
	$theme_name = get_option( 'stylesheet' );
	$nav_menu = get_option( 'theme_mods_' . strtolower( $theme_name ) );
	remove_action( 'pre_get_posts', 'home_page_feature_listing' );
	?>

<div class="off-canvas-wrap" data-offcanvas> <!-- off-canvas-wrap start -->
  <div class="inner-wrap"> <!-- inner-wrap start -->
	<nav class="tab-bar hide-for-large-up">
	  <section class="left-small">
		<a class="left-off-canvas-toggle menu-icon" href="#"><span></span></a> <!-- offcanvas icon -->
	  </section>

	  <section class="middle tab-bar-section">
		<?php if ( supreme_get_settings( 'supreme_logo_url' ) ) : ?>
				<a href="<?php echo site_url(); ?>"><h1 class="title"><img class="logo" src="<?php echo supreme_get_settings( 'supreme_logo_url' ); ?>" alt="<?php echo bloginfo( 'name' ); ?>" /></h1></a>
		<?php
				else :

					echo '<a href="' . site_url() . '"><h1 class="title">' . bloginfo( 'name' ) . '</h1></a>';

		endif; ?>
	  </section>
	</nav>

	<aside class="left-off-canvas-menu"> <!-- offcanvas side menu -->
	<?php
	if( function_exists( 'supreme_header_primary_navigation' ) ) {
		apply_filters( 'tmpl_supreme_header_primary',supreme_header_primary_navigation() ); // Loads the menu-primary template.
	}
	if ( isset( $nav_menu['nav_menu_locations'] )  && @$nav_menu['nav_menu_locations']['secondary'] != 0 ) {
		echo '<div id="nav" class="nav_bg">';
			apply_filters( 'tmpl_supreme_header_secondary',supreme_header_secondary_mobile_navigation() ); // Loads the menu-secondary template.
		echo '</div>';
	} elseif ( is_active_sidebar( 'mega_menu' ) ) {
		if ( function_exists( 'dynamic_sidebar' ) ) {
			echo '<div id="nav" class="nav_bg">
							<div id="menu-mobi-secondary" class="menu-container">
								<nav role="navigation" class="wrap">
									<div id="menu-mobi-secondary-title">';
								_e( 'Menu', 'templatic' );
						echo '</div>';
						dynamic_sidebar( 'mega_menu' ); // jQuery mega menu
			echo '</nav></div></div>';
		}
	} else {
		?>
	  <ul class="off-canvas-list">
		<?php wp_list_pages( 'title_li=&depth=0&child_of=0&number=5&show_home=1&sort_column=ID&sort_order=DESC' );?>
	  </ul>
		<?php } ?>
	  
		<?php
		if ( is_active_sidebar( 'header' ) ) :
			apply_filters( 'tmpl-header',supreme_header_sidebar() ); // Loads the sidebar-header.
	   endif;
		do_action( 'header' );
		?>
	</aside>

			<div id="container" class="container-wrap">

				<div class="header_container clearfix">
			<div class="header_strip">
				<div class="row">
					<?php
						/* Secondary navigation menu for desk top */
						do_action( 'before_desk_menu_primary' );
						supreme_secondary_navigation();
					?>

										<?php do_action( 'before_header' ); // supreme_before_header ?>
					<?php
						$header_image = get_header_image();
					if ( function_exists( 'get_header_image_location' ) ) {
						$header_image_location = get_header_image_location(); // 0 = before secondary navigation menu, 1 = after secondary navigation menu
					} else {
						$header_image_location = 1;
					}
					?>
				</div>                	
			</div>
		</div>
		<header id="header" class="mobile_header_tag clearfix">
			<?php do_action( 'open_header' ); // supreme_open_header ?>
			   <div class="header-wrap row">
					<div id="branding" class="large-4 columns">
						<hgroup>
						<?php
						if ( supreme_get_settings( 'display_header_text' ) ) {
							if ( supreme_get_settings( 'supreme_logo_url' ) ) : ?>
							<div id="site-title">
								<a href="<?php echo home_url(); ?>/" title="<?php echo bloginfo( 'name' ); ?>" rel="Home">
									<img class="logo" src="<?php echo supreme_get_settings( 'supreme_logo_url' ); ?>" alt="<?php echo bloginfo( 'name' ); ?>" />
								</a>
							</div>
							<?php else :
								supreme_site_title();
							endif;
						}

						if ( supreme_get_settings( 'supreme_site_description' ) ) : // If hide description setting is un-checked, display the site description.
							supreme_site_description();
						endif; ?>
						</hgroup>
					</div><!-- #branding -->
					<div class="large-8 columns">
						<?php
						do_action( 'header' ); // supreme_header ?>
					</div>                          
			   </div><!-- .wrap -->
				<?php if ( ! empty( $header_image ) && $header_image_location == 0 ) { ?>
						 <div class="templatic_header_image"><img src="<?php echo esc_url( $header_image ); ?>" class="header-image" width="<?php echo get_custom_header()->width; ?>" height="<?php echo get_custom_header()->height; ?>" alt="" /></div>
				<?php	} ?>
				<?php do_action( 'close_header' ); // supreme_close_header ?>

						 </header><!-- #header -->
			<?php
			$tmpdata = get_option( 'templatic_settings' );
			$map_class = (isset( $tmpdata['google_map_full_width'] ) && $tmpdata['google_map_full_width'] == 'yes')?'clearfix map_full_width':'map_fixed_width';
			if ( ( ! is_page() && ! is_author() && ! is_404() && ! is_singular()) || (is_front_page() || is_home() || $post->ID == get_option( 'page_on_front' )) ) :
				?>
				<div class="home_page_banner clear clearfix <?php echo $map_class;?>">
			<?php
			if ( ! empty( $header_image ) && $header_image_location == 1 ) { ?>
				<div class="templatic_header_image"><img src="<?php echo esc_url( $header_image ); ?>" class="header-image" width="<?php echo get_custom_header()->width; ?>" height="<?php echo get_custom_header()->height; ?>" alt="" /></div>
			<?php } ?>
					<?php do_action( 'before_main' ); // supreme_before_main ?>

						   </div>
					<?php endif;?>

		  
				 <section id="main" class="clearfix">

			<div class="wrap row">
					<?php do_action( 'tmpl_open_wrap' ); ?>
					<header id="header" class="window_header clearfix">
							<?php do_action( 'open_header' ); // supreme_open_header ?>
						 <div class="header-wrap">
								<?php if ( supreme_get_settings( 'display_header_text' ) ) { ?>
							  <div id="branding">
								   <hgroup>
									<?php
									if ( supreme_get_settings( 'display_header_text' ) ) {
										if ( supreme_get_settings( 'supreme_logo_url' ) ) : ?>
												<div id="site-title">
													<a href="<?php echo home_url(); ?>/" title="<?php echo bloginfo( 'name' ); ?>" rel="Home">
														<img class="logo" src="<?php echo supreme_get_settings( 'supreme_logo_url' ); ?>" alt="<?php echo bloginfo( 'name' ); ?>" />
													</a>
												</div>
											<?php else :
													supreme_site_title();
									endif;
									}

									if ( supreme_get_settings( 'supreme_site_description' ) ) : // If hide description setting is un-checked, display the site description.
										supreme_site_description();
										endif; ?>
								   </hgroup>
							  </div><!-- #branding -->

															<?php } ?>
								<?php
									do_action( 'header' ); // supreme_header ?>
						 </div><!-- .wrap -->
							<?php if ( ! empty( $header_image ) && $header_image_location == 0 ) { ?>
								   <div class="templatic_header_image"><img src="<?php echo esc_url( $header_image ); ?>" class="header-image" width="<?php echo get_custom_header()->width; ?>" height="<?php echo get_custom_header()->height; ?>" alt="" /></div>
							<?php	} ?>
							<?php do_action( 'close_header' ); // supreme_close_header ?>

							<div class="ctynamemob">
								<?php
									global $current_cityinfo;
									$city_slug = str_replace( ' ','-',strtolower( $current_cityinfo['cityname'] ) );
									if ( function_exists( 'icl_register_string' ) ) {
									if ( $current_cityinfo['city_id'] == 0 ) {
									$cityname = icl_t( 'location-manager', 'location_city_global_city', $current_cityinfo['cityname'] );
									} else {
									$cityname = icl_t( 'location-manager', 'location_city_' . $city_slug, $current_cityinfo['cityname'] );
									}
									} else {
									$cityname = $current_cityinfo['cityname'];
									}
									echo $cityname;
								?>
							</div>

											 </header><!-- #header -->
		

			<?php do_action( 'open_main' ); // supreme_open_main ?>
